/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugRepaintingUI
extends AbstractBufferedLayerUI<JComponent>
implements ActionListener {
    private Map<Shape, DebugPainterEntry> shapeMap = new HashMap<Shape, DebugPainterEntry>();
    private final Timer timer;

    public DebugRepaintingUI() {
        this(50);
    }

    public DebugRepaintingUI(int delay) {
        this.timer = new Timer(delay, this);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        Shape clip = g2.getClip();
        if (!this.isDirty() && clip != null && !this.shapeMap.containsKey(clip)) {
            Rectangle bounds = clip.getBounds();
            BufferedImage buf = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics2D bufg = buf.createGraphics();
            bufg.setColor(Color.WHITE);
            bufg.fillRect(0, 0, buf.getWidth(), buf.getHeight());
            bufg.setXORMode(Color.BLACK);
            bufg.drawImage(this.getBuffer(), 0, 0, bounds.width, bounds.height, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, null);
            bufg.dispose();
            this.shapeMap.put(clip, new DebugPainterEntry(buf, bounds.x, bounds.y));
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
        Set<Shape> shapes = this.shapeMap.keySet();
        Iterator<Shape> iterator = shapes.iterator();
        while (iterator.hasNext()) {
            Shape shape = iterator.next();
            DebugPainterEntry entry = this.shapeMap.get(shape);
            if (entry.alpha <= 0.0f) {
                iterator.remove();
                continue;
            }
            g2.setComposite(AlphaComposite.getInstance(3, entry.alpha));
            g2.drawImage(entry.image, entry.x, entry.y, null);
            DebugPainterEntry debugPainterEntry = entry;
            debugPainterEntry.alpha = (float)((double)debugPainterEntry.alpha - 0.1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.shapeMap.isEmpty()) {
            this.setDirty(true);
        } else {
            this.timer.stop();
        }
    }

    private static class DebugPainterEntry {
        private Image image;
        private int x;
        private int y;
        private float alpha = 1.0f;

        public DebugPainterEntry(Image image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }
    }
}

