/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.jxlayer.JXLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerUI<V extends Component>
extends ComponentUI
implements Serializable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void paint(Graphics g, JComponent c) {
        c.paint(g);
    }

    public void eventDispatched(AWTEvent e, JXLayer<? extends V> l) {
    }

    public void updateUI(JXLayer<? extends V> l) {
    }

    @Override
    public void installUI(JComponent c) {
        this.addPropertyChangeListener((JXLayer)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.removePropertyChangeListener((JXLayer)c);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent evt, JXLayer<? extends V> l) {
    }

    public Dimension getPreferredScrollableViewportSize(JXLayer<? extends V> l) {
        if (l.getView() instanceof Scrollable) {
            return ((Scrollable)l.getView()).getPreferredScrollableViewportSize();
        }
        return l.getPreferredSize();
    }

    public int getScrollableBlockIncrement(JXLayer<? extends V> l, Rectangle visibleRect, int orientation, int direction) {
        if (l.getView() instanceof Scrollable) {
            return ((Scrollable)l.getView()).getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    public boolean getScrollableTracksViewportHeight(JXLayer<? extends V> l) {
        if (l.getView() instanceof Scrollable) {
            return ((Scrollable)l.getView()).getScrollableTracksViewportHeight();
        }
        if (l.getParent() instanceof JViewport) {
            return ((JViewport)l.getParent()).getHeight() > l.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth(JXLayer<? extends V> l) {
        if (l.getView() instanceof Scrollable) {
            return ((Scrollable)l.getView()).getScrollableTracksViewportWidth();
        }
        if (l.getParent() instanceof JViewport) {
            return ((JViewport)l.getParent()).getWidth() > l.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(JXLayer<? extends V> l, Rectangle visibleRect, int orientation, int direction) {
        if (l.getView() instanceof Scrollable) {
            return ((Scrollable)l.getView()).getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }
}

