/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedLayerUI<V extends JComponent>
extends AbstractBufferedLayerUI<V> {
    private LayerEffect[] effects = new LayerEffect[0];
    private Shape clip;
    private Composite composite;
    private Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>(0);
    private AffineTransform transform;
    private boolean incrementalUpdate = true;

    public LayerEffect[] getLayerEffects() {
        LayerEffect[] result = new LayerEffect[this.effects.length];
        System.arraycopy(this.effects, 0, result, 0, result.length);
        return result;
    }

    @Override
    protected LayerEffect[] getLayerEffects(JXLayer<? extends V> l) {
        return this.getLayerEffects();
    }

    public void setLayerEffects(LayerEffect ... effects) {
        LayerEffect effect;
        LayerEffect[] oldEffects = this.getLayerEffects();
        if (effects == null) {
            effects = new LayerEffect[]{};
        }
        LayerEffect[] layerEffectArray = this.getLayerEffects();
        int n = layerEffectArray.length;
        int n2 = 0;
        while (n2 < n) {
            effect = layerEffectArray[n2];
            effect.removePropertyChangeListener(this);
            ++n2;
        }
        this.effects = new LayerEffect[effects.length];
        System.arraycopy(effects, 0, this.effects, 0, effects.length);
        layerEffectArray = effects;
        n = effects.length;
        n2 = 0;
        while (n2 < n) {
            effect = layerEffectArray[n2];
            effect.addPropertyChangeListener(this);
            ++n2;
        }
        this.firePropertyChange("layerEffects", oldEffects, effects);
    }

    public Shape getClip() {
        return this.clip;
    }

    @Override
    protected Shape getClip(JXLayer<? extends V> l) {
        return this.getClip();
    }

    public void setClip(Shape clip) {
        Shape oldClip = this.getClip();
        this.clip = clip;
        this.firePropertyChange("clip", oldClip, clip);
    }

    public Composite getComposite() {
        return this.composite;
    }

    @Override
    protected Composite getComposite(JXLayer<? extends V> l) {
        return this.getComposite();
    }

    public void setComposite(Composite composite) {
        Composite oldComposite = this.getComposite();
        this.composite = composite;
        this.firePropertyChange("composite", oldComposite, composite);
    }

    public float getAlpha() {
        if (this.composite instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)this.composite;
            return ac.getAlpha();
        }
        return 1.0f;
    }

    public void setAlpha(float alpha) {
        this.setComposite(AlphaComposite.getInstance(3, alpha));
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return Collections.unmodifiableMap(this.renderingHints);
    }

    @Override
    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<? extends V> l) {
        return this.getRenderingHints();
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> renderingHints) {
        Map<RenderingHints.Key, Object> oldRenderingHints = this.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new HashMap<RenderingHints.Key, Object>();
        }
        this.renderingHints = renderingHints;
        this.firePropertyChange("renderingHints", oldRenderingHints, renderingHints);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    protected AffineTransform getTransform(JXLayer<? extends V> l) {
        return this.getTransform();
    }

    public void setTransform(AffineTransform transform) {
        AffineTransform oldTransform = this.getTransform();
        this.transform = transform;
        this.firePropertyChange("transform", oldTransform, transform);
    }

    public boolean isIncrementalUpdate() {
        return this.incrementalUpdate;
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends V> l) {
        return this.isIncrementalUpdate();
    }

    public void setIncrementalUpdate(boolean incrementalUpdate) {
        boolean oldIncrementalUpdate = this.isIncrementalUpdate();
        this.incrementalUpdate = incrementalUpdate;
        this.firePropertyChange("incrementalUpdate", oldIncrementalUpdate, incrementalUpdate);
    }
}

