/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockableUI
extends AbstractBufferedLayerUI<JComponent> {
    private boolean isLocked;
    private Component recentFocusOwner;
    private Cursor lockedCursor = Cursor.getPredefinedCursor(3);
    private LayerEffect[] lockedEffects = new LayerEffect[0];
    private final FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (e.getOppositeComponent() != null) {
                LockableUI.this.setDirty(true);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    };

    public LockableUI() {
        this(null);
    }

    public LockableUI(LayerEffect ... lockedEffects) {
        this.setLockedEffects(lockedEffects);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeFocusListener(this.focusListener);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean isLocked) {
        if (isLocked != this.isLocked()) {
            if (this.getLayer() != null) {
                boolean isFocusInsideLayer;
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component focusOwner = kfm.getPermanentFocusOwner();
                boolean bl = isFocusInsideLayer = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.getLayer());
                if (isLocked) {
                    if (isFocusInsideLayer && kfm.getFocusedWindow() == SwingUtilities.getWindowAncestor(this.getLayer())) {
                        this.recentFocusOwner = focusOwner;
                        this.getLayer().requestFocusInWindow();
                    } else {
                        this.setDirty(true);
                    }
                    this.getLayer().getGlassPane().setCursor(this.getLockedCursor());
                } else {
                    ((JComponent)this.getLayer().getView()).setVisible(true);
                    if (isFocusInsideLayer && this.recentFocusOwner != null) {
                        this.recentFocusOwner.requestFocusInWindow();
                    }
                    this.recentFocusOwner = null;
                    this.getLayer().getGlassPane().setCursor(null);
                }
            }
            this.isLocked = isLocked;
            this.firePropertyChange("locked", !isLocked, isLocked);
        }
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends JComponent> l) {
        return !this.isLocked();
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        if (this.isLocked()) {
            l.getView().setVisible(true);
            l.paint(g2);
            l.getView().setVisible(false);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        c.paint(g);
    }

    public Cursor getLockedCursor() {
        return this.lockedCursor;
    }

    public void setLockedCursor(Cursor lockedCursor) {
        Cursor oldCursor = this.getLockedCursor();
        this.lockedCursor = lockedCursor;
        this.firePropertyChange("lockedCursor", oldCursor, lockedCursor);
        if (this.isLocked()) {
            this.getLayer().getGlassPane().setCursor(lockedCursor);
        }
    }

    public LayerEffect[] getLockedEffects() {
        LayerEffect[] result = new LayerEffect[this.lockedEffects.length];
        System.arraycopy(this.lockedEffects, 0, result, 0, result.length);
        return result;
    }

    protected LayerEffect[] getLockedEffects(JXLayer<? extends JComponent> l) {
        return this.getLockedEffects();
    }

    public void setLockedEffects(LayerEffect ... lockedEffects) {
        LayerEffect[] oldEffects = this.getLockedEffects();
        if (lockedEffects == null) {
            lockedEffects = new LayerEffect[]{};
        }
        LayerEffect[] layerEffectArray = this.getLockedEffects();
        int n = layerEffectArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayerEffect effect = layerEffectArray[n2];
            effect.removePropertyChangeListener(this);
            ++n2;
        }
        this.lockedEffects = new LayerEffect[lockedEffects.length];
        System.arraycopy(lockedEffects, 0, this.lockedEffects, 0, lockedEffects.length);
        layerEffectArray = lockedEffects;
        n = lockedEffects.length;
        n2 = 0;
        while (n2 < n) {
            LayerEffect lockedEffect = layerEffectArray[n2];
            lockedEffect.addPropertyChangeListener(this);
            ++n2;
        }
        this.firePropertyChange("lockedEffects", oldEffects, lockedEffects);
    }

    @Override
    protected LayerEffect[] getLayerEffects(JXLayer<? extends JComponent> l) {
        if (this.isLocked()) {
            return this.getLockedEffects(l);
        }
        return super.getLayerEffects(l);
    }
}

