/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import javax.swing.border.Border;

/**
 * Scales (resizes) a special type of <code>Border</code>.
 */
public interface BorderScaler {

    /**
     * Returns the type of component this class can scale.
     * 
     * @return Component class.
     */
    public Class<? extends Border> getType();

    /**
     * Creates a container for the original border values.
     * 
     * @param border
     *            Border (not yet scaled).
     * @param registry
     *            Current registry.
     * 
     * @return Container component.
     */
    public ScaledBorder createScaledBorder(Border border, ScalableLayoutRegistry registry);

    /**
     * Resize the Border.
     * 
     * @param original
     *            Original (unchanged) border.
     * @param factor
     *            Factor to use.
     * @param registry
     *            Current registry.
     * @return Scaled border.
     */
    public Border scale(ScaledBorder original, double factor, ScalableLayoutRegistry registry);

}
