/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appletviewer;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.net.URL;
import java.util.Map;

import org.fuin.utils4j.Utils4J;

/**
 * Stub for a simple applet.
 */
public final class SimpleAppletStub implements AppletStub {

    private final URL baseUrl;

    private final SimpleAppletContext appletContext;

    private final Map<String, String> params;

    /**
     * Constructor with all necessary arguments.
     * 
     * @param appletContext
     *            Applet context - Cannot be <code>null</code>.
     * @param params
     *            Arguments - Cannot be <code>null</code>.
     * @param baseUrl
     *            Base URL - Cannot be <code>null</code>.
     */
    public SimpleAppletStub(final SimpleAppletContext appletContext,
            final Map<String, String> params, final URL baseUrl) {
        super();

        Utils4J.checkNotNull("appletContext", appletContext);
        this.appletContext = appletContext;

        Utils4J.checkNotNull("params", params);
        this.params = params;

        Utils4J.checkNotNull("baseUrl", baseUrl);
        this.baseUrl = baseUrl;

    }

    /**
     * {@inheritDoc}
     */
    public final void appletResize(final int width, final int height) {
        appletContext.getApplet().setSize(width, height);
    }

    /**
     * {@inheritDoc}
     */
    public final AppletContext getAppletContext() {
        return appletContext;
    }

    /**
     * {@inheritDoc}
     */
    public final URL getCodeBase() {
        return baseUrl;
    }

    /**
     * {@inheritDoc}
     */
    public final URL getDocumentBase() {
        return baseUrl;
    }

    /**
     * {@inheritDoc}
     */
    public final String getParameter(final String key) {
        return params.get(key);
    }

    /**
     * {@inheritDoc}
     */
    public final boolean isActive() {
        return true;
    }

}
