/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;
import org.fuin.utils4swing.layout.scalable.ScaledBorder;
import org.fuin.utils4swing.layout.scalable.ScaledTitledBorder;

public final class TitledBorderScaler
implements BorderScaler {
    @Override
    public final Class<? extends Border> getType() {
        return TitledBorder.class;
    }

    @Override
    public ScaledBorder createScaledBorder(Border border, ScalableLayoutRegistry registry) {
        if (!(border instanceof TitledBorder)) {
            throw new IllegalArgumentException("The argument 'border' is not a 'TitledBorder'!");
        }
        return new ScaledTitledBorder((TitledBorder)border, registry);
    }

    @Override
    public final Border scale(ScaledBorder original, double factor, ScalableLayoutRegistry registry) {
        if (!(original instanceof ScaledTitledBorder)) {
            throw new IllegalArgumentException("The argument 'original' is not a 'ScaledTitledBorder'!");
        }
        ScaledTitledBorder scaledTitledBorder = (ScaledTitledBorder)original;
        TitledBorder titledBorder = scaledTitledBorder.getTitledBorder();
        ScaledBorder innerBorder = scaledTitledBorder.getInnerBorder();
        BorderScaler scaler = registry.getBorderScaler(innerBorder.getBorder().getClass());
        Border scaledInnerBorder = scaler.scale(innerBorder, factor, registry);
        Font titleFont = ScalableLayoutUtils.scale(titledBorder.getTitleFont(), factor);
        return BorderFactory.createTitledBorder(scaledInnerBorder, titledBorder.getTitle(), titledBorder.getTitleJustification(), titledBorder.getTitlePosition(), titleFont, titledBorder.getTitleColor());
    }
}

