/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.BorderLayout;
import java.awt.Container;
import org.fuin.utils4swing.layout.scalable.ScalableLayout2;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public final class ScalableBorderLayout
extends ScalableLayout2 {
    private final BorderLayout orgLayout;
    private final int orgHgap;
    private final int orgVgap;

    public ScalableBorderLayout(ScalableLayoutRegistry registry, Container container) {
        super(registry, container);
        if (!(container.getLayout() instanceof BorderLayout)) {
            throw new IllegalArgumentException("The layout of argument 'container' is no 'BorderLayout'! [" + container.getLayout() + "]");
        }
        this.orgLayout = (BorderLayout)container.getLayout();
        this.orgHgap = this.orgLayout.getHgap();
        this.orgVgap = this.orgLayout.getVgap();
    }

    @Override
    public final void afterComponentsScaled(double factor) {
        this.orgLayout.setHgap(ScalableLayoutUtils.scale(this.orgHgap, factor));
        this.orgLayout.setVgap(ScalableLayoutUtils.scale(this.orgVgap, factor));
        this.getContainer().setLayout(this.orgLayout);
        try {
            this.orgLayout.invalidateLayout(this.getContainer());
        }
        finally {
            this.getContainer().setLayout(this);
        }
    }
}

