/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScaledBorder;

public final class LineBorderScaler
implements BorderScaler {
    @Override
    public final Class<? extends Border> getType() {
        return LineBorder.class;
    }

    @Override
    public ScaledBorder createScaledBorder(Border border, ScalableLayoutRegistry registry) {
        return new ScaledBorder(border);
    }

    @Override
    public final Border scale(ScaledBorder original, double factor, ScalableLayoutRegistry registry) {
        if (!(original.getBorder() instanceof LineBorder)) {
            throw new IllegalArgumentException("The argument 'original' does not contain a 'LineBorder'!");
        }
        LineBorder border = (LineBorder)original.getBorder();
        int thickness = (int)Math.round((double)border.getThickness() * factor);
        return BorderFactory.createLineBorder(border.getLineColor(), thickness);
    }
}

