/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jeta.forms.components.panel.FormPanel;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.appstarter.AppStarter;
import org.fuin.utils4swing.appstarter.AppStarterConfig;
import org.fuin.utils4swing.appstarter.ClasspathBinDirEntry;
import org.fuin.utils4swing.appstarter.ClasspathEntry;
import org.fuin.utils4swing.appstarter.ClasspathEntryTableFormat;
import org.fuin.utils4swing.appstarter.ClasspathJarFileEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarsDirEntry;
import org.fuin.utils4swing.appstarter.StartApplicationException;
import org.fuin.utils4swing.appstarter.StartType;

public final class AppStarterConfigPanel
extends FormPanel {
    private static final long serialVersionUID = 1L;
    private final EventList<ClasspathEntry> classpathEntries;
    private final EventList<String> arguments;
    private final AppStarter appStarter;
    private File lastDir = new File(".");

    public AppStarterConfigPanel(AppStarterConfig config, AppStarter appStarter) {
        super("AppStarterConfig.jfrm");
        Utils4J.checkNotNull((String)"config", (Object)config);
        Utils4J.checkNotNull((String)"appStarter", (Object)appStarter);
        this.appStarter = appStarter;
        this.classpathEntries = new BasicEventList();
        this.classpathEntries.addAll(config.getClassPath());
        this.arguments = new BasicEventList();
        this.arguments.addAll(config.getArguments());
        this.init();
        this.getTextFieldMainClass().setText(config.getMainClass());
        this.getComboboxStartType().setSelectedItem(config.getStartType().getName());
        this.getLabelTitle().setText(config.getFrameTitle());
    }

    private void init() {
        int width = this.getPreferredSize().width + 15;
        int height = this.getPreferredSize().height + 35;
        this.setPreferredSize(new Dimension(width, height));
        this.getTableClassPath().setModel((TableModel)new EventTableModel(this.classpathEntries, (TableFormat)new ClasspathEntryTableFormat()));
        this.getTableClassPath().setAutoResizeMode(0);
        TableColumn colType = this.getTableClassPath().getColumnModel().getColumn(0);
        colType.setPreferredWidth(100);
        TableColumn colValue = this.getTableClassPath().getColumnModel().getColumn(1);
        colValue.setPreferredWidth(430);
        this.getTableClassPath().setSelectionMode(0);
        this.getTableClassPath().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AppStarterConfigPanel.this.getButtonRemoveClassPath().setEnabled(AppStarterConfigPanel.this.getTableClassPath().getSelectedRowCount() > 0);
            }
        });
        this.getListArguments().setModel(new EventListModel(this.arguments));
        this.getListArguments().setSelectionMode(0);
        this.getListArguments().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AppStarterConfigPanel.this.getButtonRemoveArgument().setEnabled(AppStarterConfigPanel.this.getListArguments().getSelectedIndex() > -1);
            }
        });
        DefaultComboBoxModel modelStartTypes = (DefaultComboBoxModel)this.getComboboxStartType().getModel();
        StartType[] startTypeArray = StartType.INSTANCES;
        int n = StartType.INSTANCES.length;
        int n2 = 0;
        while (n2 < n) {
            StartType element = startTypeArray[n2];
            modelStartTypes.addElement(element.getName());
            ++n2;
        }
        this.getButtonAddJarFileClassPath().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.addJarFileClassPath();
            }
        });
        this.getButtonAddJarsDirClassPath().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.addJarsDirClassPath();
            }
        });
        this.getButtonAddBinDirClassPath().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.addBinDirClassPath();
            }
        });
        this.getButtonRemoveClassPath().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.removeClassPath();
            }
        });
        this.getButtonAddArgument().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.addArgument();
            }
        });
        this.getButtonRemoveArgument().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.removeArgument();
            }
        });
        this.getButtonStartApplication().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppStarterConfigPanel.this.startApplication();
            }
        });
    }

    private JTable getTableClassPath() {
        return this.getTable("TableClassPath");
    }

    private JButton getButtonAddJarsDirClassPath() {
        return (JButton)this.getButton("ButtonAddJarsDirClassPath");
    }

    private JButton getButtonAddBinDirClassPath() {
        return (JButton)this.getButton("ButtonAddBinDirClassPath");
    }

    private JButton getButtonRemoveClassPath() {
        return (JButton)this.getButton("ButtonRemoveClassPath");
    }

    private JButton getButtonAddJarFileClassPath() {
        return (JButton)this.getButton("ButtonAddJarFileClassPath");
    }

    private JComboBox getComboboxStartType() {
        return this.getComboBox("ComboboxStartType");
    }

    private JTextField getTextFieldMainClass() {
        return this.getTextField("TextFieldMainClass");
    }

    private JTextField getTextFieldAddArgument() {
        return this.getTextField("TextFieldAddArgument");
    }

    private JButton getButtonAddArgument() {
        return (JButton)this.getButton("ButtonAddArgument");
    }

    private JButton getButtonRemoveArgument() {
        return (JButton)this.getButton("ButtonRemoveArgument");
    }

    private JButton getButtonStartApplication() {
        return (JButton)this.getButton("ButtonStartApplication");
    }

    private JLabel getLabelMainClass() {
        return this.getLabel("LabelMainClass");
    }

    private JLabel getLabelClassPath() {
        return this.getLabel("LabelClassPath");
    }

    private JLabel getLabelTitle() {
        return this.getLabel("LabelTitle");
    }

    private JScrollPane getScrollPaneClasspath() {
        return (JScrollPane)this.getComponentByName("ScrollPaneClasspath");
    }

    private JScrollPane getScrollPaneArguments() {
        return (JScrollPane)this.getComponentByName("ScrollPaneArguments");
    }

    private JList getListArguments() {
        return this.getList("ListArguments");
    }

    private void addJarFileClassPath() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.lastDir);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Jar files (*.jar)";
            }
        });
        int choice = chooser.showOpenDialog((Component)((Object)this));
        if (choice != 1) {
            this.classpathEntries.add((Object)new ClasspathJarFileEntry(chooser.getSelectedFile().getAbsolutePath()));
            this.lastDir = chooser.getSelectedFile().getParentFile();
        }
    }

    private void addBinDirClassPath() {
        JDirectoryChooser chooser = new JDirectoryChooser();
        chooser.setCurrentDirectory(new File("."));
        int choice = chooser.showOpenDialog((Component)((Object)this));
        if (choice != 1) {
            this.classpathEntries.add((Object)new ClasspathBinDirEntry(chooser.getSelectedFile().getAbsolutePath()));
            this.lastDir = chooser.getSelectedFile();
        }
    }

    private void addJarsDirClassPath() {
        JDirectoryChooser chooser = new JDirectoryChooser();
        chooser.setCurrentDirectory(new File("."));
        int choice = chooser.showOpenDialog((Component)((Object)this));
        if (choice != 1) {
            this.classpathEntries.add((Object)new ClasspathJarsDirEntry(chooser.getSelectedFile().getAbsolutePath()));
            this.lastDir = chooser.getSelectedFile();
        }
    }

    private void removeClassPath() {
        int row = this.getTableClassPath().getSelectedRow();
        this.classpathEntries.remove(row);
        int rowCount = this.getTableClassPath().getRowCount();
        if (rowCount == 0) {
            this.repaint(this.getScrollPaneClasspath().getBounds());
        } else {
            if (row == rowCount) {
                --row;
            }
            this.getTableClassPath().getSelectionModel().setSelectionInterval(row, row);
        }
        this.getTableClassPath().requestFocus();
    }

    private StartType getStartType() {
        String name = (String)this.getComboboxStartType().getSelectedItem();
        return StartType.forName(name);
    }

    private void addArgument() {
        String text = this.getTextFieldAddArgument().getText().trim();
        if (text.length() > 0) {
            this.arguments.add((Object)text);
            this.getTextFieldAddArgument().setText("");
        } else {
            this.showError("Please enter something in the text field before pressing the add button!");
        }
    }

    private void removeArgument() {
        int idx = this.getListArguments().getSelectedIndex();
        this.arguments.remove(idx);
        int size = this.arguments.size();
        if (size == 0) {
            this.repaint(this.getScrollPaneArguments().getBounds());
        } else {
            if (idx == size) {
                --idx;
            }
            this.getListArguments().getSelectionModel().setSelectionInterval(idx, idx);
        }
        this.getListArguments().requestFocus();
    }

    private void startApplication() {
        try {
            if (this.classpathEntries.size() == 0) {
                throw new StartApplicationException("Please add a classpath for your application in table '" + this.getLabelClassPath().getText() + "'!");
            }
            if (this.getTextFieldMainClass().getText().length() == 0) {
                throw new StartApplicationException("Please enter something in field '" + this.getLabelMainClass().getText() + "'!");
            }
            this.appStarter.start(this.getStartType(), (List<ClasspathEntry>)this.classpathEntries, this.getTextFieldMainClass().getText(), (List<String>)this.arguments);
        }
        catch (StartApplicationException e) {
            this.showError(e.getMessage());
        }
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Error", 0);
    }
}

