/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;

/**
 * Scales (resizes) a special type of component.
 */
public interface ComponentScaler {

    /**
     * Returns the type of component this class can scale.
     * 
     * @return Component class.
     */
    public Class<? extends Component> getType();

    /**
     * Creates a container for the original component values.
     * 
     * @param comp
     *            Component (not yet scaled).#
     * @param registry
     *            Current registry.
     * 
     * @return Container component.
     */
    public ScaledComponent createScaledComponent(Component comp,
            ScalableLayoutRegistry registry);

    /**
     * Resize the component.
     * 
     * @param component
     *            Component to resize.
     * @param factor
     *            Factor to use.
     * @param registry
     *            Current registry.
     */
    public void scale(ScaledComponent component, double factor,
            ScalableLayoutRegistry registry);

}
