/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import javax.swing.JComponent;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ComponentScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;
import org.fuin.utils4swing.layout.scalable.ScaledComponent;

public final class JComponentScaler
implements ComponentScaler {
    @Override
    public final Class<? extends Component> getType() {
        return JComponent.class;
    }

    @Override
    public ScaledComponent createScaledComponent(Component comp, ScalableLayoutRegistry registry) {
        return new ScaledComponent(comp, registry);
    }

    @Override
    public final void scale(ScaledComponent sc, double factor, ScalableLayoutRegistry registry) {
        if (!(sc.getComp() instanceof JComponent)) {
            throw new IllegalArgumentException("The argument 'sc' does not contain a 'JComponent' component! [" + sc.getComp() + "]");
        }
        JComponent comp = (JComponent)sc.getComp();
        comp.setFont(ScalableLayoutUtils.scale(sc.getFont(), factor));
        if (sc.getBounds() == null) {
            sc.setBounds(comp.getBounds());
        }
        comp.setBounds(ScalableLayoutUtils.scale(sc.getBounds(), factor));
        comp.setPreferredSize(ScalableLayoutUtils.scale(sc.getPreferredSize(), factor));
        comp.setMinimumSize(ScalableLayoutUtils.scale(sc.getMinimumSize(), factor));
        comp.setMaximumSize(ScalableLayoutUtils.scale(sc.getMaximumSize(), factor));
        if (comp.getBorder() != null) {
            BorderScaler bs = registry.getBorderScaler(comp.getBorder().getClass());
            comp.setBorder(bs.scale(sc.getBorder(), factor, registry));
        }
    }
}

