/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.glazedlists;

import java.util.List;
import java.util.Locale;
import org.fuin.objects4j.TableColumnInfo;
import org.fuin.srcgen4javassist.ByteCodeGenerator;
import org.fuin.srcgen4javassist.SgArgument;
import org.fuin.srcgen4javassist.SgBehavior;
import org.fuin.srcgen4javassist.SgClass;
import org.fuin.srcgen4javassist.SgClassPool;
import org.fuin.srcgen4javassist.SgMethod;
import org.fuin.utils4swing.glazedlists.TableFormatExt;

public final class TableFormatCreator<E> {
    private final ByteCodeGenerator generator;
    private final SgClassPool pool;

    public TableFormatCreator() {
        this(null, null);
    }

    public TableFormatCreator(SgClassPool pool, ByteCodeGenerator generator) {
        this.pool = pool == null ? new SgClassPool() : pool;
        this.generator = generator == null ? new ByteCodeGenerator() : generator;
    }

    public TableFormatExt<E> create(Class<E> clasz) {
        return this.create(clasz, Locale.getDefault());
    }

    public TableFormatExt<E> create(Class<E> clasz, Locale locale) {
        String implName;
        String pkg = String.valueOf(clasz.getSimpleName()) + "TableFormat_" + locale;
        Class tableFormatImpl = this.getClassSilent(pkg, implName = String.valueOf(clasz.getSimpleName()) + "TableFormat_" + locale);
        if (tableFormatImpl == null) {
            List columns = TableColumnInfo.create(clasz, (Locale)locale);
            if (columns.size() == 0) {
                throw new IllegalArgumentException("No '@TableColumn' annotations found in class '" + clasz.getName() + "'!");
            }
            SgClass tableFormatImplClass = this.createTableFormatImplClass(pkg, implName);
            this.addGetColumnCountMethod(tableFormatImplClass, columns);
            this.addGetColumnNameMethod(tableFormatImplClass, columns, clasz);
            this.addGetColumnValueMethod(tableFormatImplClass, columns, clasz);
            this.addGetColumnWidthMethod(tableFormatImplClass, columns);
            tableFormatImpl = this.generator.createClass(tableFormatImplClass);
        }
        return (TableFormatExt)this.generator.createInstance(tableFormatImpl);
    }

    private Class<TableFormatExt<E>> getClassSilent(String pkg, String implName) {
        Class<?> tableFormatImpl;
        try {
            tableFormatImpl = Class.forName(String.valueOf(pkg) + "." + implName);
        }
        catch (ClassNotFoundException e) {
            tableFormatImpl = null;
        }
        return tableFormatImpl;
    }

    private SgClass createTableFormatImplClass(String packageName, String implName) {
        String tableFormatInterfaceName = TableFormatExt.class.getName();
        SgClass tableFormatImplClass = new SgClass(packageName, implName);
        SgClass tableFormatInterface = SgClass.create((SgClassPool)this.pool, (String)tableFormatInterfaceName);
        tableFormatImplClass.addInterface(tableFormatInterface);
        return tableFormatImplClass;
    }

    private void addGetColumnWidthMethod(SgClass tableFormatImplClass, List<TableColumnInfo> columns) {
        SgMethod getColumnWidthMethod = new SgMethod(tableFormatImplClass, "public", SgClass.INT, "getColumnWidth");
        new SgArgument((SgBehavior)getColumnWidthMethod, SgClass.INT, "column");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return " + columns.get(i).getWidth().toPixel() + ";");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnWidthMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnWidthMethod);
    }

    private void addGetColumnValueMethod(SgClass tableFormatImplClass, List<TableColumnInfo> columns, Class<E> clasz) {
        SgMethod getColumnValueMethod = new SgMethod(tableFormatImplClass, "public", SgClass.OBJECT, "getColumnValue");
        new SgArgument((SgBehavior)getColumnValueMethod, SgClass.OBJECT, "obj");
        new SgArgument((SgBehavior)getColumnValueMethod, SgClass.INT, "column");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return ((" + clasz.getName() + ")obj)." + columns.get(i).getGetter() + "();");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnValueMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnValueMethod);
    }

    private void addGetColumnNameMethod(SgClass tableFormatImplClass, List<TableColumnInfo> columns, Class<E> clasz) {
        SgMethod getColumnNameMethod = new SgMethod(tableFormatImplClass, "public", SgClass.create((SgClassPool)this.pool, (String)"java.lang.String"), "getColumnName");
        new SgArgument((SgBehavior)getColumnNameMethod, SgClass.INT, "column");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columns.size()) {
            if (i == 0) {
                sb.append("if (column == " + i + ") {");
            } else {
                sb.append("} else if (column == " + i + ") {");
            }
            sb.append("return \"" + columns.get(i).getText() + "\";");
            ++i;
        }
        sb.append("}");
        sb.append("throw new IllegalStateException(\"Unknown colum # \" + column);");
        getColumnNameMethod.addBodyLine(sb.toString());
        tableFormatImplClass.addMethod(getColumnNameMethod);
    }

    private void addGetColumnCountMethod(SgClass tableFormatImplClass, List<TableColumnInfo> columns) {
        SgMethod getColumnCountMethod = new SgMethod(tableFormatImplClass, "public", SgClass.INT, "getColumnCount");
        getColumnCountMethod.addBodyLine("return " + columns.size() + ";");
        tableFormatImplClass.addMethod(getColumnCountMethod);
    }
}

