/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fuin.utils4swing.appstarter.ClasspathBinDirEntry;
import org.fuin.utils4swing.appstarter.ClasspathEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarFileEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarsDirEntry;
import org.fuin.utils4swing.appstarter.StartType;
import org.kohsuke.args4j.Option;

public class AppStarterConfig {
    private final List<ClasspathEntry> classPath;
    private final List<String> arguments;
    private StartType startType = StartType.APPLICATION;
    private String mainClass = "";
    private String frameTitle = "AppStarter";

    public AppStarterConfig() {
        this.classPath = new ArrayList<ClasspathEntry>();
        this.arguments = new ArrayList<String>();
    }

    public final List<String> getArguments() {
        return this.arguments;
    }

    @Option(name="-arguments", usage="Sets one or more arguments separated by a comma")
    public final void setArguments(String args) {
        StringTokenizer tok = new StringTokenizer(args, ",");
        while (tok.hasMoreTokens()) {
            this.arguments.add(tok.nextToken());
        }
    }

    public final void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public final List<ClasspathEntry> getClassPath() {
        return this.classPath;
    }

    public final void addClasspathEntry(ClasspathEntry entry) {
        this.classPath.add(entry);
    }

    @Option(name="-classpathEntries", usage="Sets one or more classpath separated by a komma and with format 'TYPE|VALUE'")
    public final void setClassPath(String cp) {
        StringTokenizer tok = new StringTokenizer(cp, ",");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.startsWith("JAR_FILE|")) {
                this.classPath.add(new ClasspathJarFileEntry(str.substring("JAR_FILE".length() + 1)));
                continue;
            }
            if (str.startsWith("JARS_DIR|")) {
                this.classPath.add(new ClasspathJarsDirEntry(str.substring("JARS_DIR".length() + 1)));
                continue;
            }
            if (str.startsWith("CLASSES_DIR|")) {
                this.classPath.add(new ClasspathBinDirEntry(str.substring("CLASSES_DIR".length() + 1)));
                continue;
            }
            throw new IllegalArgumentException("The classpath type for '" + str + "' is unknown!");
        }
    }

    public final String getMainClass() {
        return this.mainClass;
    }

    @Option(name="-mainClass", usage="Sets the main class to start")
    public final void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public final StartType getStartType() {
        return this.startType;
    }

    @Option(name="-startType", usage="Sets the start type ('Application' or 'Applet')")
    public final void setStartType(String startType) {
        this.startType = StartType.forName(startType);
    }

    public final void setStartType(StartType startType) {
        this.startType = startType;
    }

    public final String getFrameTitle() {
        return this.frameTitle;
    }

    @Option(name="-frameTitle", usage="Sets the title for the frame")
    public final void setFrameTitle(String frameTitle) {
        this.frameTitle = frameTitle;
    }
}

