/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appletviewer;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.appletviewer.SimpleAppletContext;
import org.fuin.utils4swing.appletviewer.SimpleAppletStub;
import org.fuin.utils4swing.appletviewer.SimpleAppletViewerConfig;
import org.fuin.utils4swing.common.FramePositioner;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public final class SimpleAppletViewer {
    private final SimpleAppletViewerConfig config;
    private final Applet applet;

    public SimpleAppletViewer(SimpleAppletViewerConfig config) {
        Utils4J.checkNotNull((String)"config", (Object)config);
        this.config = config;
        this.applet = config.getApplet();
        if (this.applet == null) {
            throw new IllegalArgumentException("The 'applet' field in 'config' cannot be null!");
        }
    }

    public final void execute() {
        String appletName = this.config.getName() == null ? this.applet.getClass().getSimpleName() : this.config.getName();
        this.applet.setPreferredSize(new Dimension(this.config.getWidth(), this.config.getHeight()));
        final JFrame viewerFrame = Utils4Swing.createShowAndPosition((String)(String.valueOf(this.config.getTitle()) + ": " + appletName), (Container)this.applet, (boolean)true, (boolean)true, (FramePositioner)new ScreenCenterPositioner());
        SimpleAppletContext appletContext = new SimpleAppletContext(this.applet, appletName);
        final SimpleAppletStub appletStub = new SimpleAppletStub(appletContext, this.config.getParams(), this.config.getBaseUrl());
        viewerFrame.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                appletStub.appletResize(viewerFrame.getWidth(), viewerFrame.getHeight());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.applet.setStub(appletStub);
        this.applet.init();
        this.applet.start();
    }

    public static void main(String[] args) {
        final SimpleAppletViewerConfig config = new SimpleAppletViewerConfig();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Utils4Swing.initSystemLookAndFeel();
                    new SimpleAppletViewer(config).execute();
                }
            });
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java SimpleAppletViewer [options] [Applet arguments]");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
    }
}

