/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import javax.swing.border.TitledBorder;

/**
 * Helper class for scaled borders.
 */
public final class ScaledTitledBorder extends ScaledBorder {

    private final ScaledBorder innerBorder;

    /**
     * Constructor with component.
     * 
     * @param border
     *            Border (not yet scaled).
     * @param registry
     *            Registry to use.
     */
    public ScaledTitledBorder(final TitledBorder border, final ScalableLayoutRegistry registry) {
        super(border);
        if (border.getBorder() == null) {
            innerBorder = null;
        } else {
            final BorderScaler scaler = registry
                    .getBorderScaler(border.getBorder().getClass());
            innerBorder = scaler.createScaledBorder(border.getBorder(), registry);
        }
    }

    /**
     * return the original border.
     * 
     * @return Border.
     */
    public final TitledBorder getTitledBorder() {
        return (TitledBorder) getBorder();
    }

    /**
     * Returns the original inner border.
     * 
     * @return Inner border.
     */
    public final ScaledBorder getInnerBorder() {
        return innerBorder;
    }

}
