/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

/**
 * Scales a <code>LineBorder</code>.
 */
public final class LineBorderScaler implements BorderScaler {

    /**
     * {@inheritDoc}
     */
    public final Class<? extends Border> getType() {
        return LineBorder.class;
    }

    /**
     * {@inheritDoc}
     */
    public ScaledBorder createScaledBorder(final Border border,
            final ScalableLayoutRegistry registry) {
        return new ScaledBorder(border);
    }

    /**
     * {@inheritDoc}
     */
    public final Border scale(final ScaledBorder original, final double factor,
            final ScalableLayoutRegistry registry) {
        if (!(original.getBorder() instanceof LineBorder)) {
            throw new IllegalArgumentException(
                    "The argument 'original' does not contain a 'LineBorder'!");
        }
        final LineBorder border = (LineBorder) original.getBorder();
        final int thickness = (int) Math.round(border.getThickness() * factor);
        return BorderFactory.createLineBorder(border.getLineColor(), thickness);
    }

}
