/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScaledBorder;

public final class ScaledComponent {
    private final Component comp;
    private final Font font;
    private final Dimension preferredSize;
    private final Dimension minimumSize;
    private final Dimension maximumSize;
    private final ScaledBorder border;
    private Rectangle bounds;

    public ScaledComponent(Component comp, ScalableLayoutRegistry registry) {
        Utils4J.checkNotNull((String)"comp", (Object)comp);
        this.comp = comp;
        Utils4J.checkNotNull((String)"registry", (Object)registry);
        this.font = comp.getFont();
        this.bounds = null;
        this.preferredSize = comp.getPreferredSize() == null ? null : new Dimension(comp.getPreferredSize());
        this.minimumSize = comp.getMinimumSize() == null ? null : new Dimension(comp.getMinimumSize());
        this.maximumSize = comp.getMaximumSize() == null ? null : new Dimension(comp.getMaximumSize());
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            if (jc.getBorder() == null) {
                this.border = null;
            } else {
                BorderScaler scaler = registry.getBorderScaler(jc.getBorder().getClass());
                this.border = scaler.createScaledBorder(jc.getBorder(), registry);
            }
        } else {
            this.border = null;
        }
    }

    public final Component getComp() {
        return this.comp;
    }

    public final Font getFont() {
        return this.font;
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final void setBounds(Rectangle rectangle) {
        this.bounds = new Rectangle(rectangle);
    }

    public final Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public final Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public final Dimension getMaximumSize() {
        return this.maximumSize;
    }

    public final ScaledBorder getBorder() {
        return this.border;
    }
}

