/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.fuin.utils4swing.layout.scalable.AbstractScalableLayout;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;

public abstract class ScalableLayout2
extends AbstractScalableLayout
implements LayoutManager2 {
    private final LayoutManager2 originalLayout;

    public ScalableLayout2(ScalableLayoutRegistry registry, Container container) {
        super(registry, container);
        if (!(container.getLayout() instanceof LayoutManager2)) {
            throw new IllegalArgumentException("The layout manager of 'container' is not type 'LayoutManager2'! [" + container.getLayout() + "]");
        }
        this.originalLayout = (LayoutManager2)container.getLayout();
    }

    public final void addLayoutComponent(Component comp, Object constraints) {
        this.addScaledComponent(comp);
        this.originalLayout.addLayoutComponent(comp, constraints);
    }

    public final Dimension maximumLayoutSize(Container target) {
        return this.originalLayout.maximumLayoutSize(target);
    }

    public final float getLayoutAlignmentX(Container target) {
        return this.originalLayout.getLayoutAlignmentX(target);
    }

    public final float getLayoutAlignmentY(Container target) {
        return this.originalLayout.getLayoutAlignmentY(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateLayout(Container target) {
        if (this.originalLayout != null) {
            this.getContainer().setLayout(this.originalLayout);
            try {
                this.originalLayout.invalidateLayout(this.getContainer());
            }
            finally {
                this.getContainer().setLayout(this);
            }
        }
    }

    public final LayoutManager2 getOriginalLayout() {
        return this.originalLayout;
    }
}

