/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ComponentScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;
import org.fuin.utils4swing.layout.scalable.ScaledBorder;
import org.fuin.utils4swing.layout.scalable.ScaledComponent;

public abstract class AbstractScalableLayout
implements LayoutManager {
    private double factor = 1.0;
    private final Font orgFont;
    private final Insets orgInsets;
    private final ScaledBorder orgBorder;
    private final LayoutManager orgLayout;
    private final Container container;
    private final List<ScaledComponent> components = new ArrayList<ScaledComponent>();
    private final ScalableLayoutRegistry registry;

    protected AbstractScalableLayout(ScalableLayoutRegistry registry, Container container) {
        Utils4J.checkNotNull((String)"registry", (Object)registry);
        this.registry = registry;
        Utils4J.checkNotNull((String)"container", (Object)container);
        this.container = container;
        this.orgLayout = container.getLayout();
        this.orgFont = container.getFont();
        Insets in = container.getInsets();
        this.orgInsets = new Insets(in.top, in.left, in.bottom, in.right);
        if (container instanceof JComponent) {
            Border border = ((JComponent)container).getBorder();
            if (border == null) {
                this.orgBorder = null;
            } else {
                BorderScaler scaler = registry.getBorderScaler(border.getClass());
                this.orgBorder = scaler.createScaledBorder(border, registry);
            }
        } else {
            this.orgBorder = null;
        }
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            this.addScaledComponent(comps[i]);
        }
    }

    public final void addLayoutComponent(String name, Component comp) {
        this.addScaledComponent(comp);
        if (this.orgLayout != null) {
            this.orgLayout.addLayoutComponent(name, comp);
        }
    }

    protected final void addScaledComponent(Component comp) {
        ComponentScaler scaler = this.registry.getComponentScaler(comp.getClass());
        ScaledComponent sc = scaler.createScaledComponent(comp, this.registry);
        this.components.add(sc);
    }

    public final void removeLayoutComponent(Component comp) {
        ScaledComponent sc = this.findScaledComponent(comp);
        if (sc != null) {
            this.components.remove(sc);
        }
        if (this.orgLayout != null) {
            this.orgLayout.removeLayoutComponent(comp);
        }
    }

    protected final ScaledComponent findScaledComponent(Component comp) {
        for (int i = 0; i < this.components.size(); ++i) {
            ScaledComponent sc = this.components.get(i);
            if (sc.getComp() != comp) continue;
            return sc;
        }
        return null;
    }

    public final Dimension preferredLayoutSize(Container container) {
        if (this.orgLayout == null) {
            return null;
        }
        return this.orgLayout.preferredLayoutSize(container);
    }

    public final Dimension minimumLayoutSize(Container container) {
        if (this.orgLayout == null) {
            return null;
        }
        return this.orgLayout.minimumLayoutSize(container);
    }

    private void scaleComponents() {
        if (this.container instanceof JComponent) {
            JComponent jc = (JComponent)this.container;
            if (jc.getBorder() == null) {
                ScalableLayoutUtils.scale(this.container.getInsets(), this.orgInsets, this.factor);
            } else {
                BorderScaler bs = this.registry.getBorderScaler(jc.getBorder().getClass());
                jc.setBorder(bs.scale(this.orgBorder, this.factor, this.registry));
            }
        } else {
            ScalableLayoutUtils.scale(this.container.getInsets(), this.orgInsets, this.factor);
        }
        this.container.setFont(ScalableLayoutUtils.scale(this.orgFont, this.factor));
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            ScaledComponent scaledComponent = this.findScaledComponent(comp);
            if (scaledComponent == null) {
                throw new IllegalStateException("Component not found: " + comp);
            }
            ComponentScaler scaler = this.registry.getComponentScaler(scaledComponent.getComp().getClass());
            scaler.scale(scaledComponent, this.factor, this.registry);
        }
        this.afterComponentsScaled(this.factor);
    }

    public final double getFactor() {
        return this.factor;
    }

    public final void setFactor(double factor) {
        this.factor = factor;
        this.scaleComponents();
        this.layoutContainer(this.container);
    }

    public final void setFactorRecursive(double factor) {
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            AbstractScalableLayout.setFactorRecursive(comp, factor);
        }
        this.factor = factor;
        this.scaleComponents();
        this.layoutContainer(this.container);
    }

    public abstract void afterComponentsScaled(double var1);

    private static void setFactorRecursive(Component comp, double factor) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            if (cont instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)cont;
                for (int j = 0; j < tabbedPane.getComponentCount(); ++j) {
                    Component tabComponent = tabbedPane.getComponent(j);
                    AbstractScalableLayout.setFactorRecursive(tabComponent, factor);
                }
            } else if (cont.getLayout() instanceof AbstractScalableLayout) {
                AbstractScalableLayout layout = (AbstractScalableLayout)cont.getLayout();
                layout.setFactorRecursive(factor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layoutContainer(Container container) {
        if (this.orgLayout != null) {
            container.setLayout(this.orgLayout);
            try {
                this.orgLayout.layoutContainer(container);
            }
            finally {
                container.setLayout(this);
            }
        }
    }

    protected final Container getContainer() {
        return this.container;
    }
}

