/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/**
 * Scales a <code>TitledBorder</code>.
 */
public final class TitledBorderScaler implements BorderScaler {

    /**
     * {@inheritDoc}
     */
    public final Class<? extends Border> getType() {
        return TitledBorder.class;
    }

    /**
     * {@inheritDoc}
     */
    public ScaledBorder createScaledBorder(final Border border,
            final ScalableLayoutRegistry registry) {
        if (!(border instanceof TitledBorder)) {
            throw new IllegalArgumentException(
                    "The argument 'border' is not a 'TitledBorder'!");
        }
        return new ScaledTitledBorder((TitledBorder) border, registry);
    }

    /**
     * {@inheritDoc}
     */
    public final Border scale(final ScaledBorder original, final double factor,
            final ScalableLayoutRegistry registry) {
        
        if (!(original instanceof ScaledTitledBorder)) {
            throw new IllegalArgumentException(
                    "The argument 'original' is not a 'ScaledTitledBorder'!");
        }
        final ScaledTitledBorder scaledTitledBorder = (ScaledTitledBorder) original;
        final TitledBorder titledBorder = scaledTitledBorder.getTitledBorder();
        final ScaledBorder innerBorder = scaledTitledBorder.getInnerBorder();
        final BorderScaler scaler = registry.getBorderScaler(innerBorder.getBorder()
                .getClass());
        final Border scaledInnerBorder = scaler.scale(innerBorder, factor, registry);
        final Font titleFont = ScalableLayoutUtils.scale(titledBorder.getTitleFont(), factor);
        return BorderFactory.createTitledBorder(scaledInnerBorder, titledBorder.getTitle(),
                titledBorder.getTitleJustification(), titledBorder.getTitlePosition(),
                titleFont, titledBorder.getTitleColor());

    }

}
