/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import javax.swing.border.Border;

import org.fuin.utils4j.Utils4J;

/**
 * Helper class for scaled borders.
 */
public class ScaledBorder {

    private final Border border;

    /**
     * Constructor with component.
     * 
     * @param border
     *            Border (not yet scaled) - Cannot be <code>null</code>.
     */
    public ScaledBorder(final Border border) {
        super();
        Utils4J.checkNotNull("border", border);        
        this.border = border;
    }

    /**
     * Original border.
     * 
     * @return Border.
     */
    public final Border getBorder() {
        return border;
    }

}
