/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import java.awt.Container;

import javax.swing.border.Border;

/**
 * Registry of known helper classes for scaling components and layouts.
 */
public interface ScalableLayoutRegistry {

    /**
     * Returns a helper class that can be used to scale a component.
     * 
     * @param componentClass
     *            Class to find a scaler for.
     * 
     * @return Class used to scale that type of component - Always non-null!
     */
    public ComponentScaler getComponentScaler(Class<? extends Component> componentClass);

    /**
     * Returns a helper class that can be used to scale a border.
     * 
     * @param borderClass
     *            Class to find a scaler for.
     * 
     * @return Class used to scale that type of border - Always non-null!
     */
    public BorderScaler getBorderScaler(Class<? extends Border> borderClass);

    /**
     * Returns a scalable replacement for the original layout manager.
     * 
     * @param registry
     *            Registry to use.
     * @param container
     *            Container with the original layout.
     * 
     * @return Scalable layout manager - Always non-null!
     */
    public AbstractScalableLayout getScalableLayout(ScalableLayoutRegistry registry,
            Container container);

    /**
     * Checks if a given component should be treated as container. This
     * method will be used when setting scalable layout managers recursive.
     * 
     * @param component
     *            Component to check.
     * 
     * @return If it's a container (means no controls like "JTextField",
     *         "JButton"...) <code>true</code> else <code>false</code>.
     */
    public boolean isContainer(Component component);

}
