/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.BorderLayout;
import java.awt.Container;

/**
 * A layout manager that resizes the content along to a given factor.
 */
public final class ScalableBorderLayout extends ScalableLayout2 {

    private final BorderLayout orgLayout;
    
    private final int orgHgap;

    private final int orgVgap;

    /**
     * Constructor with registry and container.
     * 
     * @param registry
     *            Registry to use.
     * @param container
     *            Container this layout should be applied to.
     */
    public ScalableBorderLayout(final ScalableLayoutRegistry registry, final Container container) {
        super(registry, container);
        if (!(container.getLayout() instanceof BorderLayout)) {
            throw new IllegalArgumentException(
                    "The layout of argument 'container' is no 'BorderLayout'! ["
                            + container.getLayout() + "]");
        }
        orgLayout = (BorderLayout) container.getLayout();
        this.orgHgap = orgLayout.getHgap();
        this.orgVgap = orgLayout.getVgap();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final void afterComponentsScaled(final double factor) {
        
        orgLayout.setHgap(ScalableLayoutUtils.scale(orgHgap, factor));
        orgLayout.setVgap(ScalableLayoutUtils.scale(orgVgap, factor));
        
        getContainer().setLayout(orgLayout);
        try {
            orgLayout.invalidateLayout(getContainer());
        } finally {
            getContainer().setLayout(this);
        }
    }

}
