/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;

/**
 * Scales any AWT component.
 */
public final class DefaultComponentScaler implements ComponentScaler {

    /**
     * {@inheritDoc}
     */
    public final Class<? extends Component> getType() {
        return Component.class;
    }

    /**
     * {@inheritDoc}
     */
    public ScaledComponent createScaledComponent(final Component comp,
            final ScalableLayoutRegistry registry) {
        return new ScaledComponent(comp, registry);
    }

    /**
     * {@inheritDoc}
     */
    public final void scale(final ScaledComponent sc, final double factor,
            final ScalableLayoutRegistry registry) {
        final Component comp = sc.getComp();
        comp.setFont(ScalableLayoutUtils.scale(sc.getFont(), factor));
        if (sc.getBounds() == null) {
            // First call
            sc.setBounds(comp.getBounds());
        }
        comp.setBounds(ScalableLayoutUtils.scale(sc.getBounds(), factor));
        comp.setPreferredSize(ScalableLayoutUtils.scale(sc.getPreferredSize(), factor));
        comp.setMinimumSize(ScalableLayoutUtils.scale(sc.getMinimumSize(), factor));
        comp.setMaximumSize(ScalableLayoutUtils.scale(sc.getMaximumSize(), factor));
    }

}
