/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appstarter;

import java.io.File;

import org.fuin.utils4j.Utils4J;

/**
 * Directory with several classes ("bin" or "classes" folder) to be added to the
 * classpath.
 */
public final class ClasspathBinDirEntry implements ClasspathEntry {

    /** Unique type name. */
    public static final String TYPE = "CLASSES_DIR";

    private final File dir;

    /**
     * Constructor with directory name.
     * 
     * @param dir
     *            Path.
     */
    public ClasspathBinDirEntry(final String dir) {
        this(new File(dir));
    }

    /**
     * Constructor with directory reference.
     * 
     * @param dir
     *            Directory - Cannot be <code>null</code> and must exist.
     */
    public ClasspathBinDirEntry(final File dir) {
        super();
        Utils4J.checkNotNull("dir", dir);
        Utils4J.checkValidDir(dir);
        this.dir = dir;
    }

    /**
     * {@inheritDoc}
     */
    public final String getType() {
        return TYPE;
    }

    /**
     * {@inheritDoc}
     */
    public final String getValue() {
        return dir.toString();
    }

    /**
     * {@inheritDoc}
     */
    public final void addToClasspath() {
        Utils4J.addToClasspath(dir.toURI().toString());
    }

}
