/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.threadsafe;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class ThreadSafeJOptionPane {
    private ThreadSafeJOptionPane() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    private static int execute(final IntOptionPane optionPane) {
        final IntResult result = new IntResult();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    optionPane.show(result);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return result.getResult();
    }

    private static String execute(final StringOptionPane optionPane) {
        final StringResult result = new StringResult();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    optionPane.show(result);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return result.getResult();
    }

    private static Object execute(final ObjectOptionPane optionPane) {
        final ObjectResult result = new ObjectResult();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    optionPane.show(result);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return result.getResult();
    }

    private static void execute(final VoidOptionPane optionPane) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    optionPane.show();
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int showConfirmDialog(final Component parentComponent, final Object message) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showConfirmDialog(parentComponent, message));
            }
        });
    }

    public static int showConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showConfirmDialog(parentComponent, message, title, optionType));
            }
        });
    }

    public static int showConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType));
            }
        });
    }

    public static int showConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType, final Icon icon) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon));
            }
        });
    }

    public static String showInputDialog(final Component parentComponent, final Object message) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInputDialog(parentComponent, message));
            }
        });
    }

    public static String showInputDialog(final Component parentComponent, final Object message, final Object initialSelectionValue) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInputDialog(parentComponent, message, initialSelectionValue));
            }
        });
    }

    public static String showInputDialog(final Component parentComponent, final Object message, final String title, final int messageType) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInputDialog(parentComponent, message, title, messageType));
            }
        });
    }

    public static Object showInputDialog(final Component parentComponent, final Object message, final String title, final int messageType, final Icon icon, final Object[] selectionValues, final Object initialSelectionValue) {
        return ThreadSafeJOptionPane.execute(new ObjectOptionPane(){

            public void show(ObjectResult result) {
                result.setResult(JOptionPane.showInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue));
            }
        });
    }

    public static String showInputDialog(final Object message) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInputDialog(message));
            }
        });
    }

    public static String showInputDialog(final Object message, final Object initialSelectionValue) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInputDialog(message, initialSelectionValue));
            }
        });
    }

    public static int showInternalConfirmDialog(final Component parentComponent, final Object message) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showInternalConfirmDialog(parentComponent, message));
            }
        });
    }

    public static int showInternalConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType));
            }
        });
    }

    public static int showInternalConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType));
            }
        });
    }

    public static int showInternalConfirmDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType, final Icon icon) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType, icon));
            }
        });
    }

    public static String showInternalInputDialog(final Component parentComponent, final Object message) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInternalInputDialog(parentComponent, message));
            }
        });
    }

    public static String showInternalInputDialog(final Component parentComponent, final Object message, final String title, final int messageType) {
        return ThreadSafeJOptionPane.execute(new StringOptionPane(){

            public void show(StringResult result) {
                result.setResult(JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType));
            }
        });
    }

    public static Object showInternalInputDialog(final Component parentComponent, final Object message, final String title, final int messageType, final Icon icon, final Object[] selectionValues, final Object initialSelectionValue) {
        return ThreadSafeJOptionPane.execute(new ObjectOptionPane(){

            public void show(ObjectResult result) {
                result.setResult(JOptionPane.showInternalInputDialog(parentComponent, message, title, messageType, icon, selectionValues, initialSelectionValue));
            }
        });
    }

    public static void showInternalMessageDialog(final Component parentComponent, final Object message) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showInternalMessageDialog(parentComponent, message);
            }
        });
    }

    public static void showInternalMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showInternalMessageDialog(parentComponent, message, title, messageType);
            }
        });
    }

    public static void showInternalMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType, final Icon icon) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showInternalMessageDialog(parentComponent, message, title, messageType, icon);
            }
        });
    }

    public static int showInternalOptionDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType, final Icon icon, final Object[] options, final Object initialValue) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showInternalOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue));
            }
        });
    }

    public static void showMessageDialog(final Component parentComponent, final Object message) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showMessageDialog(parentComponent, message);
            }
        });
    }

    public static void showMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
            }
        });
    }

    public static void showMessageDialog(final Component parentComponent, final Object message, final String title, final int messageType, final Icon icon) {
        ThreadSafeJOptionPane.execute(new VoidOptionPane(){

            public void show() {
                JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
            }
        });
    }

    public static int showOptionDialog(final Component parentComponent, final Object message, final String title, final int optionType, final int messageType, final Icon icon, final Object[] options, final Object initialValue) {
        return ThreadSafeJOptionPane.execute(new IntOptionPane(){

            public void show(IntResult result) {
                result.setResult(JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue));
            }
        });
    }

    private static interface IntOptionPane {
        public void show(IntResult var1);
    }

    private static class IntResult {
        private volatile int result = 0;

        private IntResult() {
        }

        public void setResult(int result) {
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }
    }

    private static interface ObjectOptionPane {
        public void show(ObjectResult var1);
    }

    private static class ObjectResult {
        private volatile Object result = null;

        private ObjectResult() {
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static interface StringOptionPane {
        public void show(StringResult var1);
    }

    private static class StringResult {
        private volatile String result = null;

        private StringResult() {
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }
    }

    private static interface VoidOptionPane {
        public void show();
    }
}

