/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.dialogs.DirectorySelector;

public class DirectorySelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelTitle = null;
    private JPanel panelButtons = null;
    private JPanel panelDirectory = null;
    private JLabel labelTitle = null;
    private JButton buttonOK = null;
    private JButton buttonCancel = null;
    private JTextField textFieldDirectory = null;
    private JButton buttonDirectory = null;
    private DirectorySelector destDirSelector = null;
    private JCheckBox checkBoxIncludeSubdirs = null;

    public DirectorySelectionPanel(DirectorySelector destDirSelector) {
        this.initialize();
        Utils4J.checkNotNull((String)"destDirSelector", (Object)destDirSelector);
        this.destDirSelector = destDirSelector;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(450, 130);
        this.setPreferredSize(new Dimension(450, 130));
        this.add((Component)this.getPanelTitle(), "North");
        this.add((Component)this.getPanelButtons(), "South");
        this.add((Component)this.getPanelDirectory(), "Center");
    }

    private JLabel getLabelTitle() {
        if (this.labelTitle == null) {
            this.labelTitle = new JLabel();
            this.labelTitle.setText("Please select the destination directory:");
        }
        return this.labelTitle;
    }

    private JPanel getPanelTitle() {
        if (this.panelTitle == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setAlignment(0);
            flowLayout.setVgap(10);
            this.panelTitle = new JPanel();
            this.panelTitle.setLayout(flowLayout);
            this.panelTitle.setPreferredSize(new Dimension(40, 30));
            this.panelTitle.add((Component)this.getLabelTitle(), null);
        }
        return this.panelTitle;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setAlignment(2);
            flowLayout2.setVgap(10);
            flowLayout2.setHgap(10);
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(flowLayout2);
            this.panelButtons.setPreferredSize(new Dimension(200, 45));
            this.panelButtons.add((Component)this.getCheckBoxIncludeSubdirs(), null);
            this.panelButtons.add((Component)this.getButtonCancel(), null);
            this.panelButtons.add((Component)this.getButtonOK(), null);
        }
        return this.panelButtons;
    }

    private JPanel getPanelDirectory() {
        if (this.panelDirectory == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.gridx = 0;
            this.panelDirectory = new JPanel();
            this.panelDirectory.setLayout(new GridBagLayout());
            this.panelDirectory.add((Component)this.getTextFieldDirectory(), gridBagConstraints);
            this.panelDirectory.add((Component)this.getButtonDirectory(), gridBagConstraints1);
        }
        return this.panelDirectory;
    }

    private JButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new JButton();
            this.buttonOK.setText("OK");
            this.buttonOK.setPreferredSize(new Dimension(80, 26));
            this.buttonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DirectorySelectionPanel.this.destDirSelector != null) {
                        DirectorySelectionPanel.this.destDirSelector.ok();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setText("Cancel");
            this.buttonCancel.setPreferredSize(new Dimension(80, 26));
            this.buttonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (DirectorySelectionPanel.this.destDirSelector != null) {
                        DirectorySelectionPanel.this.destDirSelector.cancel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    private JTextField getTextFieldDirectory() {
        if (this.textFieldDirectory == null) {
            this.textFieldDirectory = new JTextField();
        }
        return this.textFieldDirectory;
    }

    private JButton getButtonDirectory() {
        if (this.buttonDirectory == null) {
            this.buttonDirectory = new JButton();
            this.buttonDirectory.setPreferredSize(new Dimension(40, 20));
            this.buttonDirectory.setText("...");
            this.buttonDirectory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DirectorySelectionPanel.this.selectDirectory();
                }
            });
        }
        return this.buttonDirectory;
    }

    private JCheckBox getCheckBoxIncludeSubdirs() {
        if (this.checkBoxIncludeSubdirs == null) {
            this.checkBoxIncludeSubdirs = new JCheckBox();
            this.checkBoxIncludeSubdirs.setText("Include Subdirectories");
            this.checkBoxIncludeSubdirs.setPreferredSize(new Dimension(250, 24));
            this.checkBoxIncludeSubdirs.setVisible(true);
        }
        return this.checkBoxIncludeSubdirs;
    }

    private void selectDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(this.getTextFieldDirectory().getText()));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            try {
                this.setDirectoryIntern(chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException e) {
                this.setDirectoryIntern(chooser.getSelectedFile().toString());
            }
        }
    }

    private void setDirectoryIntern(String directory) {
        this.getTextFieldDirectory().setText(directory);
    }

    public final void setDirectory(final String directory) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDirectoryIntern(directory);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DirectorySelectionPanel.this.setDirectoryIntern(directory);
                    }
                });
            }
            catch (Exception ex) {
                DirectorySelectionPanel.ignore();
            }
        }
    }

    private void setTitleIntern(String title) {
        this.getLabelTitle().setText(title);
    }

    public final void setTitle(final String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setTitleIntern(title);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DirectorySelectionPanel.this.setTitleIntern(title);
                    }
                });
            }
            catch (Exception ex) {
                DirectorySelectionPanel.ignore();
            }
        }
    }

    private void setIncludeSubdirsVisibleIntern(boolean b) {
        this.getCheckBoxIncludeSubdirs().setVisible(b);
    }

    public final void setIncludeSubdirsVisible(final boolean b) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setIncludeSubdirsVisibleIntern(b);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DirectorySelectionPanel.this.setIncludeSubdirsVisibleIntern(b);
                    }
                });
            }
            catch (Exception ex) {
                DirectorySelectionPanel.ignore();
            }
        }
    }

    public final String getDirectory() {
        return this.getTextFieldDirectory().getText().trim();
    }

    public final boolean isIncludeSubdirs() {
        return this.getCheckBoxIncludeSubdirs().isSelected();
    }

    private static void ignore() {
    }
}

