/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import org.fuin.utils4swing.layout.scalable.AbstractScalableLayout;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;

public final class ScalableLayoutUtils {
    private static final int WIDTH_FIX = 3;

    private ScalableLayoutUtils() {
        throw new UnsupportedOperationException("Cannot create instance of utility class!");
    }

    public static Font scale(Font font, double factor) {
        if (font == null) {
            return null;
        }
        int size = (int)Math.round((double)font.getSize() * factor);
        return new Font(font.getName(), font.getStyle(), size);
    }

    public static Rectangle scale(Rectangle rect, double factor) {
        if (rect == null) {
            return null;
        }
        int height = (int)Math.round((double)rect.height * factor);
        int width = (int)Math.round((double)rect.width * factor) + 3;
        int x = (int)Math.round((double)rect.x * factor);
        int y = (int)Math.round((double)rect.y * factor);
        return new Rectangle(x, y, width, height);
    }

    public static Dimension scale(Dimension dim, double factor) {
        if (dim == null) {
            return null;
        }
        int height = (int)Math.round((double)dim.height * factor);
        int width = (int)Math.round((double)dim.width * factor) + 3;
        return new Dimension(width, height);
    }

    public static int scale(int value, double factor) {
        return (int)Math.round((double)value * factor);
    }

    public static void scale(Insets current, Insets original, double factor) {
        if (original != null && current != null) {
            current.bottom = (int)Math.round((double)original.bottom * factor);
            current.left = (int)Math.round((double)original.left * factor);
            current.right = (int)Math.round((double)original.right * factor);
            current.top = (int)Math.round((double)original.top * factor);
        }
    }

    public static void installScaleKeys(RootPaneContainer rootPaneContainer, final AbstractScalableLayout layout, double step) {
        Container contentPane = rootPaneContainer.getContentPane();
        if (!(contentPane instanceof JComponent)) {
            throw new IllegalArgumentException("The content pane of the root container is not of type 'JComponent'! [" + contentPane.getClass().getName() + "]");
        }
        JComponent comp = (JComponent)contentPane;
        comp.getInputMap(2).put(KeyStroke.getKeyStroke(107, 2), "SCALE_UP");
        comp.getActionMap().put("SCALE_UP", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                double factor = layout.getFactor() + 0.1;
                layout.setFactorRecursive(factor);
            }
        });
        comp.getInputMap(2).put(KeyStroke.getKeyStroke(109, 2), "SCALE_DN");
        comp.getActionMap().put("SCALE_DN", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                double factor = layout.getFactor() - 0.1;
                layout.setFactorRecursive(factor);
            }
        });
    }

    public static void installScalableLayout(ScalableLayoutRegistry registry, Container container) {
        AbstractScalableLayout layout = registry.getScalableLayout(registry, container);
        container.setLayout(layout);
    }

    public static void installScalableLayoutRecursive(ScalableLayoutRegistry registry, Container container) {
        Component[] comps = container.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (registry.isContainer(comps[i])) {
                ScalableLayoutUtils.installScalableLayoutRecursive(registry, (Container)comps[i]);
            }
            ++i;
        }
        ScalableLayoutUtils.installScalableLayout(registry, container);
    }

    public static void installScalableLayoutAndKeys(ScalableLayoutRegistry registry, RootPaneContainer rootPaneContainer, double step) {
        Container contentPane = rootPaneContainer.getContentPane();
        ScalableLayoutUtils.installScalableLayoutRecursive(registry, contentPane);
        ScalableLayoutUtils.installScaleKeys(rootPaneContainer, (AbstractScalableLayout)contentPane.getLayout(), step);
    }
}

