/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import org.fuin.utils4swing.layout.scalable.ComponentScaler;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;
import org.fuin.utils4swing.layout.scalable.ScaledComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSpinnerScaler
implements ComponentScaler {
    @Override
    public final Class<? extends Component> getType() {
        return JSpinner.class;
    }

    @Override
    public final ScaledComponent createScaledComponent(Component comp, ScalableLayoutRegistry registry) {
        return new ScaledComponent(comp, registry);
    }

    @Override
    public final void scale(ScaledComponent sc, double factor, ScalableLayoutRegistry registry) {
        if (!(sc.getComp() instanceof JSpinner)) {
            throw new IllegalArgumentException("The argument 'sc' does not contain a 'JSpinner' component!");
        }
        JSpinner spinner = (JSpinner)sc.getComp();
        spinner.setFont(ScalableLayoutUtils.scale(sc.getFont(), factor));
        if (sc.getBounds() == null) {
            sc.setBounds(spinner.getBounds());
        }
        spinner.setBounds(ScalableLayoutUtils.scale(sc.getBounds(), factor));
        spinner.setPreferredSize(ScalableLayoutUtils.scale(sc.getPreferredSize(), factor));
        spinner.setMinimumSize(ScalableLayoutUtils.scale(sc.getMinimumSize(), factor));
        spinner.setMaximumSize(ScalableLayoutUtils.scale(sc.getMaximumSize(), factor));
        JComponent comp = spinner.getEditor();
        if (comp instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)comp;
            JFormattedTextField tf = defaultEditor.getTextField();
            tf.setFont(ScalableLayoutUtils.scale(sc.getFont(), factor));
        }
    }
}

