/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.layout.scalable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.fuin.utils4swing.layout.scalable.AbstractScalableLayout;
import org.fuin.utils4swing.layout.scalable.BorderScaler;
import org.fuin.utils4swing.layout.scalable.ComponentScaler;
import org.fuin.utils4swing.layout.scalable.DefaultBorderScaler;
import org.fuin.utils4swing.layout.scalable.DefaultComponentScaler;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayout;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayout2;
import org.fuin.utils4swing.layout.scalable.JComponentScaler;
import org.fuin.utils4swing.layout.scalable.JSpinnerScaler;
import org.fuin.utils4swing.layout.scalable.LineBorderScaler;
import org.fuin.utils4swing.layout.scalable.ScalableBorderLayout;
import org.fuin.utils4swing.layout.scalable.ScalableLayout;
import org.fuin.utils4swing.layout.scalable.ScalableLayout2;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.TitledBorderScaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultScalableLayoutRegistry
implements ScalableLayoutRegistry {
    private static final String NEW_INSTANCE_ERROR = "Cannot create a new scalabla layout manager instance!";
    private final List<ComponentScaler> componentScalerList = new ArrayList<ComponentScaler>();
    private final DefaultComponentScaler defaultComponentScaler;
    private final List<BorderScaler> borderScalerList;
    private final DefaultBorderScaler defaultBorderScaler;
    private final Map<Class<? extends LayoutManager2>, Class<? extends ScalableLayout2>> scalableLayouts2;
    private final Map<Class<? extends LayoutManager>, Class<? extends ScalableLayout>> scalableLayouts;

    public DefaultScalableLayoutRegistry() {
        this.componentScalerList.add(new JSpinnerScaler());
        this.componentScalerList.add(new JComponentScaler());
        this.defaultComponentScaler = new DefaultComponentScaler();
        this.borderScalerList = new ArrayList<BorderScaler>();
        this.borderScalerList.add(new TitledBorderScaler());
        this.borderScalerList.add(new LineBorderScaler());
        this.defaultBorderScaler = new DefaultBorderScaler();
        this.scalableLayouts2 = new HashMap<Class<? extends LayoutManager2>, Class<? extends ScalableLayout2>>();
        this.scalableLayouts2.put(BorderLayout.class, ScalableBorderLayout.class);
        this.scalableLayouts = new HashMap<Class<? extends LayoutManager>, Class<? extends ScalableLayout>>();
    }

    public final void addScaler(ComponentScaler scaler) {
        this.componentScalerList.add(scaler);
    }

    public final boolean removeScaler(ComponentScaler scaler) {
        return this.componentScalerList.remove(scaler);
    }

    @Override
    public final ComponentScaler getComponentScaler(Class<? extends Component> componentClass) {
        int i = 0;
        while (i < this.componentScalerList.size()) {
            ComponentScaler scaler = this.componentScalerList.get(i);
            if (scaler.getType().isAssignableFrom(componentClass)) {
                return scaler;
            }
            ++i;
        }
        return this.defaultComponentScaler;
    }

    public final void addScaler(BorderScaler scaler) {
        this.borderScalerList.add(scaler);
    }

    public final boolean removeScaler(BorderScaler scaler) {
        return this.borderScalerList.remove(scaler);
    }

    @Override
    public final BorderScaler getBorderScaler(Class<? extends Border> borderClass) {
        int i = 0;
        while (i < this.borderScalerList.size()) {
            BorderScaler scaler = this.borderScalerList.get(i);
            if (scaler.getType().isAssignableFrom(borderClass)) {
                return scaler;
            }
            ++i;
        }
        return this.defaultBorderScaler;
    }

    private void checkAbstractLayoutConstructor(Class<? extends AbstractScalableLayout> layoutClass) {
        try {
            layoutClass.getConstructor(ScalableLayoutRegistry.class, Container.class);
        }
        catch (SecurityException ex) {
            throw new IllegalStateException("Class loader or security problem!", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("The class must have a constructor with exact two arguments: 'ScalableLayoutRegistry' and 'Container'(in this order)!", ex);
        }
    }

    public final void putScalableLayout2(Class<? extends LayoutManager2> layoutManager2Class, Class<? extends ScalableLayout2> scalableLayout2Class) {
        this.checkAbstractLayoutConstructor(scalableLayout2Class);
        this.scalableLayouts2.put(layoutManager2Class, scalableLayout2Class);
    }

    public final void removeScalableLayout2(Class<? extends LayoutManager2> layoutManager2Class) {
        this.scalableLayouts2.remove(layoutManager2Class);
    }

    public final void putScalableLayout(Class<? extends LayoutManager> layoutManagerClass, Class<? extends ScalableLayout> scalableLayoutClass) {
        this.checkAbstractLayoutConstructor(scalableLayoutClass);
        this.scalableLayouts.put(layoutManagerClass, scalableLayoutClass);
    }

    public final void removeScalableLayout(Class<? extends LayoutManager> layoutManagerClass) {
        this.scalableLayouts.remove(layoutManagerClass);
    }

    private AbstractScalableLayout createScalableLayoutInstance(Class<? extends AbstractScalableLayout> clasz, ScalableLayoutRegistry registry, Container container) {
        try {
            Constructor<? extends AbstractScalableLayout> constructor = clasz.getConstructor(ScalableLayoutRegistry.class, Container.class);
            return constructor.newInstance(registry, container);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(NEW_INSTANCE_ERROR, ex);
        }
    }

    @Override
    public final AbstractScalableLayout getScalableLayout(ScalableLayoutRegistry registry, Container container) {
        AbstractScalableLayout layout;
        LayoutManager originalLayout = container.getLayout();
        if (originalLayout instanceof LayoutManager2) {
            Class layoutClass = null;
            for (Class<? extends LayoutManager2> clasz : this.scalableLayouts2.keySet()) {
                if (!clasz.isAssignableFrom(originalLayout.getClass())) continue;
                layoutClass = this.scalableLayouts2.get(clasz);
                break;
            }
            if (layoutClass == null) {
                layoutClass = DefaultScalableLayout2.class;
            }
            layout = this.createScalableLayoutInstance(layoutClass, registry, container);
        } else if (originalLayout == null) {
            layout = new DefaultScalableLayout(registry, container);
        } else {
            Class layoutClass = null;
            for (Class<? extends LayoutManager> clasz : this.scalableLayouts.keySet()) {
                if (!clasz.isAssignableFrom(originalLayout.getClass())) continue;
                layoutClass = this.scalableLayouts.get(clasz);
                break;
            }
            if (layoutClass == null) {
                layoutClass = DefaultScalableLayout.class;
            }
            layout = this.createScalableLayoutInstance(layoutClass, registry, container);
        }
        return layout;
    }

    @Override
    public boolean isContainer(Component container) {
        if (container instanceof JPanel) {
            return true;
        }
        return container instanceof JTabbedPane;
    }
}

