/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.annotations;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.annotations.Label;

public final class AnnotationUtils {
    private AnnotationUtils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static String getLabelText(Class clasz, String fieldName, Label label, Locale locale) {
        Utils4J.checkNotNull((String)"clasz", (Object)clasz);
        Utils4J.checkNotNull((String)"fieldName", (Object)fieldName);
        Utils4J.checkNotNull((String)"label", (Object)label);
        Utils4J.checkNotNull((String)"locale", (Object)locale);
        try {
            ResourceBundle bundle = AnnotationUtils.getResourceBundle(clasz, locale, label);
            String key = AnnotationUtils.getKey(fieldName, label);
            return AnnotationUtils.getLabelText(bundle, fieldName, label, key);
        }
        catch (MissingResourceException ex) {
            return fieldName;
        }
    }

    public static String getStandardText(Class clasz, String fieldName, Locale locale) {
        Utils4J.checkNotNull((String)"clasz", (Object)clasz);
        Utils4J.checkNotNull((String)"fieldName", (Object)fieldName);
        Utils4J.checkNotNull((String)"locale", (Object)locale);
        try {
            String path = Utils4J.getPackagePath((Class)clasz);
            ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(path) + "/" + clasz.getSimpleName(), locale);
            String value = bundle.getString(fieldName);
            if (value == null) {
                return fieldName;
            }
            return value;
        }
        catch (MissingResourceException ex) {
            return fieldName;
        }
    }

    private static String getLabelText(ResourceBundle bundle, String fieldName, Label label, String key) {
        String value = bundle.getString(key);
        String text = value == null ? (label.value().length() == 0 ? fieldName : label.value()) : value;
        return text;
    }

    private static String getKey(String fieldName, Label label) {
        String key = label.key().length() == 0 ? fieldName : label.key();
        return key;
    }

    private static ResourceBundle getResourceBundle(Class clasz, Locale locale, Label label) {
        ResourceBundle bundle;
        if (label.bundle().length() == 0) {
            String path = Utils4J.getPackagePath((Class)clasz);
            bundle = ResourceBundle.getBundle(String.valueOf(path) + "/" + clasz.getSimpleName(), locale);
        } else {
            bundle = ResourceBundle.getBundle(label.bundle(), locale);
        }
        return bundle;
    }
}

