/*
 * Decompiled with CFR 0.152.
 */
package layout.problem;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class SpringDemo4 {
    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SpringDemo4");
        frame.setDefaultCloseOperation(3);
        Container contentPane = frame.getContentPane();
        SpringLayout layout = new SpringLayout();
        contentPane.setLayout(layout);
        JLabel label = new JLabel("Label: ");
        JTextField textField = new JTextField("Text field", 15);
        contentPane.add(label);
        contentPane.add(textField);
        SpringLayout.Constraints contentPaneCons = layout.getConstraints(contentPane);
        contentPaneCons.setX(Spring.sum(Spring.constant(5), contentPaneCons.getConstraint("West")));
        contentPaneCons.setY(Spring.sum(Spring.constant(5), contentPaneCons.getConstraint("North")));
        SpringLayout.Constraints textFieldCons = layout.getConstraints(textField);
        textFieldCons.setX(Spring.sum(Spring.constant(5), contentPaneCons.getConstraint("East")));
        textFieldCons.setY(Spring.constant(5));
        SpringDemo4.setContainerSize(contentPane, 5);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SpringDemo4.createAndShowGUI();
            }
        });
    }

    public static void setContainerSize(Container parent, int pad) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component[] components = parent.getComponents();
        Spring maxHeightSpring = Spring.constant(0);
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        Component rightmost = components[components.length - 1];
        SpringLayout.Constraints rCons = layout.getConstraints(rightmost);
        pCons.setConstraint("East", Spring.sum(Spring.constant(pad), rCons.getConstraint("East")));
        int i = 0;
        while (i < components.length) {
            SpringLayout.Constraints cons = layout.getConstraints(components[i]);
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getConstraint("South"));
            ++i;
        }
        pCons.setConstraint("South", Spring.sum(Spring.constant(pad), maxHeightSpring));
    }
}

