/*
 * Decompiled with CFR 0.152.
 */
package layout.problem;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class DiagonalLayout
implements LayoutManager {
    private int vgap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;

    public DiagonalLayout() {
        this(5);
    }

    public DiagonalLayout(int v) {
        this.vgap = v;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        Dimension d = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                d = c.getPreferredSize();
                if (i > 0) {
                    this.preferredWidth += d.width / 2;
                    this.preferredHeight += this.vgap;
                } else {
                    this.preferredWidth = d.width;
                }
                this.preferredHeight += d.height;
                this.minWidth = Math.max(c.getMinimumSize().width, this.minWidth);
                this.minHeight = this.preferredHeight;
            }
            ++i;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.getComponentCount();
        this.setSizes(parent);
        Insets insets = parent.getInsets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.getComponentCount();
        Insets insets = parent.getInsets();
        dim.width = this.minWidth + insets.left + insets.right;
        dim.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int maxWidth = parent.getWidth() - (insets.left + insets.right);
        int maxHeight = parent.getHeight() - (insets.top + insets.bottom);
        int nComps = parent.getComponentCount();
        int previousWidth = 0;
        int previousHeight = 0;
        int x = 0;
        int y = insets.top;
        boolean rowh = false;
        boolean start = false;
        int xFudge = 0;
        int yFudge = 0;
        boolean oneColumn = false;
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        if (maxWidth <= this.minWidth) {
            oneColumn = true;
        }
        if (maxWidth != this.preferredWidth) {
            xFudge = (maxWidth - this.preferredWidth) / (nComps - 1);
        }
        if (maxHeight > this.preferredHeight) {
            yFudge = (maxHeight - this.preferredHeight) / (nComps - 1);
        }
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getPreferredSize();
                if (i > 0) {
                    if (!oneColumn) {
                        x += previousWidth / 2 + xFudge;
                    }
                    y += previousHeight + this.vgap + yFudge;
                }
                if (!oneColumn && x + d.width > parent.getWidth() - insets.right) {
                    x = parent.getWidth() - insets.bottom - d.width;
                }
                int cfr_ignored_0 = d.height;
                parent.getHeight();
                int cfr_ignored_1 = insets.bottom;
                c.setBounds(x, y, d.width, d.height);
                previousWidth = d.width;
                previousHeight = d.height;
            }
            ++i;
        }
    }

    public String toString() {
        String str = "";
        return String.valueOf(this.getClass().getName()) + "[vgap=" + this.vgap + str + "]";
    }
}

