/*
 * Decompiled with CFR 0.152.
 */
package layout.problem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import layout.problem.BLDComponent;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class BoxLayoutDemo2
implements ItemListener {
    protected static int NUM_COMPONENTS = 3;
    protected static float[] xAlignment = new float[]{0.0f, 0.5f, 1.0f};
    protected static float[] hue = new float[]{0.0f, 0.33f, 0.67f};
    protected static boolean restrictSize = true;
    protected static boolean sizeIsRandom = false;
    protected static BLDComponent[] bldComponent = new BLDComponent[NUM_COMPONENTS];

    public void populateContentPane(Container contentPane) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        int shortSideSize = 15;
        int i = 0;
        while (i < NUM_COMPONENTS) {
            shortSideSize = sizeIsRandom ? (int)(30.0 * Math.random()) + 30 : (shortSideSize += 10);
            BoxLayoutDemo2.bldComponent[i] = new BLDComponent(xAlignment[i], hue[i], shortSideSize, restrictSize, sizeIsRandom, String.valueOf(i));
            panel.add(bldComponent[i]);
            ++i;
        }
        JLabel label = new JLabel("Click a rectangle to change its X alignment.");
        JCheckBox cb = new JCheckBox("Restrict maximum rectangle size.");
        cb.setSelected(restrictSize);
        cb.addItemListener(this);
        panel.setBorder(BorderFactory.createLineBorder(Color.red));
        Box box = Box.createVerticalBox();
        box.add(label);
        box.add(cb);
        contentPane.add((Component)panel, "Center");
        contentPane.add((Component)box, "Last");
    }

    public void itemStateChanged(ItemEvent e) {
        restrictSize = e.getStateChange() == 1;
        BoxLayoutDemo2.notifyBLDComponents();
    }

    public static void notifyBLDComponents() {
        int i = 0;
        while (i < NUM_COMPONENTS) {
            bldComponent[i].setSizeRestriction(restrictSize);
            ++i;
        }
        bldComponent[0].revalidate();
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("BoxLayoutDemo2");
        frame.setDefaultCloseOperation(3);
        BoxLayoutDemo2 demo = new BoxLayoutDemo2();
        demo.populateContentPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoxLayoutDemo2.createAndShowGUI();
            }
        });
    }
}

