/*
 * Decompiled with CFR 0.152.
 */
package layout.problem;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class BLDComponent
extends JComponent
implements MouseListener {
    private final Color normalHue;
    private final Dimension preferredSize;
    private final String name;
    private boolean restrictMaximumSize;
    private final boolean printSize;

    public BLDComponent(float alignmentX, float hue, int shortSideSize, boolean restrictSize, boolean printSize, String name) {
        this.name = name;
        this.restrictMaximumSize = restrictSize;
        this.printSize = printSize;
        this.setAlignmentX(alignmentX);
        this.normalHue = Color.getHSBColor(hue, 0.4f, 0.85f);
        this.preferredSize = new Dimension(shortSideSize * 2, shortSideSize);
        this.addMouseListener(this);
    }

    public void mousePressed(MouseEvent e) {
        int width = this.getWidth();
        float alignment = (float)e.getX() / (float)width;
        int tmp = Math.round(alignment * 10.0f);
        alignment = (float)tmp / 10.0f;
        this.setAlignmentX(alignment);
        this.revalidate();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        float alignmentX = this.getAlignmentX();
        g.setColor(this.normalHue);
        g.fill3DRect(0, 0, width, height, true);
        g.setColor(Color.white);
        int x = (int)(alignmentX * (float)width) - 1;
        g.drawLine(x, 0, x, height - 1);
        g.setColor(Color.black);
        g.drawString(Float.toString(alignmentX), 3, height - 3);
        if (this.printSize) {
            System.out.println("BLDComponent " + this.name + ": size is " + width + "x" + height + "; preferred size is " + this.getPreferredSize().width + "x" + this.getPreferredSize().height);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public Dimension getMaximumSize() {
        if (this.restrictMaximumSize) {
            return this.preferredSize;
        }
        return super.getMaximumSize();
    }

    public void setSizeRestriction(boolean restrictSize) {
        this.restrictMaximumSize = restrictSize;
    }
}

