/*
 * Decompiled with CFR 0.152.
 */
package layout.ok;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class FlowLayoutDemo
extends JFrame {
    JRadioButton RtoLbutton;
    JRadioButton LtoRbutton;
    FlowLayout experimentLayout = new FlowLayout();
    final String RtoL = "Right to left";
    final String LtoR = "Left to right";
    JButton applyButton = new JButton("Apply component orientation");

    public FlowLayoutDemo(String name) {
        super(name);
    }

    public void addComponentsToPane(Container pane) {
        final JPanel compsToExperiment = new JPanel();
        compsToExperiment.setLayout(this.experimentLayout);
        this.experimentLayout.setAlignment(4);
        JPanel controls = new JPanel();
        controls.setLayout(new FlowLayout());
        this.LtoRbutton = new JRadioButton("Left to right");
        this.LtoRbutton.setActionCommand("Left to right");
        this.LtoRbutton.setSelected(true);
        this.RtoLbutton = new JRadioButton("Right to left");
        this.RtoLbutton.setActionCommand("Right to left");
        compsToExperiment.add(new JButton("Button 1"));
        compsToExperiment.add(new JButton("Button 2"));
        compsToExperiment.add(new JButton("Button 3"));
        compsToExperiment.add(new JButton("Long-Named Button 4"));
        compsToExperiment.add(new JButton("5"));
        compsToExperiment.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        final ButtonGroup group = new ButtonGroup();
        group.add(this.LtoRbutton);
        group.add(this.RtoLbutton);
        controls.add(this.LtoRbutton);
        controls.add(this.RtoLbutton);
        controls.add(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = group.getSelection().getActionCommand();
                if (command.equals("Left to right")) {
                    compsToExperiment.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                } else {
                    compsToExperiment.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                compsToExperiment.validate();
                compsToExperiment.repaint();
            }
        });
        pane.add((Component)compsToExperiment, "Center");
        pane.add((Component)controls, "South");
    }

    private static void createAndShowGUI() {
        FlowLayoutDemo frame = new FlowLayoutDemo("FlowLayoutDemo");
        frame.setDefaultCloseOperation(3);
        frame.addComponentsToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FlowLayoutDemo.createAndShowGUI();
            }
        });
    }
}

