/*
 * Decompiled with CFR 0.152.
 */
package layout.ok;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class CardLayoutDemo
implements ItemListener {
    JPanel cards;
    static final String BUTTONPANEL = "Card with JButtons";
    static final String TEXTPANEL = "Card with JTextField";

    public void addComponentToPane(Container pane) {
        JPanel comboBoxPane = new JPanel();
        String[] comboBoxItems = new String[]{BUTTONPANEL, TEXTPANEL};
        JComboBox<String> cb = new JComboBox<String>(comboBoxItems);
        cb.setEditable(false);
        cb.addItemListener(this);
        comboBoxPane.add(cb);
        JPanel card1 = new JPanel();
        card1.add(new JButton("Button 1"));
        card1.add(new JButton("Button 2"));
        card1.add(new JButton("Button 3"));
        JPanel card2 = new JPanel();
        card2.add(new JTextField("TextField", 20));
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)card1, BUTTONPANEL);
        this.cards.add((Component)card2, TEXTPANEL);
        pane.add((Component)comboBoxPane, "First");
        pane.add((Component)this.cards, "Center");
    }

    public void itemStateChanged(ItemEvent evt) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, (String)evt.getItem());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("CardLayoutDemo");
        frame.setDefaultCloseOperation(3);
        CardLayoutDemo demo = new CardLayoutDemo();
        demo.addComponentToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CardLayoutDemo.createAndShowGUI();
            }
        });
    }
}

