/*
 * Decompiled with CFR 0.152.
 */
package layout.ok;

import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class BoxLayoutDemo {
    public static void addComponentsToPane(Container pane) {
        pane.setLayout(new BoxLayout(pane, 1));
        BoxLayoutDemo.addAButton("Button 1", pane);
        BoxLayoutDemo.addAButton("Button 2", pane);
        BoxLayoutDemo.addAButton("Button 3", pane);
        BoxLayoutDemo.addAButton("Long-Named Button 4", pane);
        BoxLayoutDemo.addAButton("5", pane);
    }

    private static void addAButton(String text, Container container) {
        JButton button = new JButton(text);
        button.setAlignmentX(0.5f);
        container.add(button);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("BoxLayoutDemo");
        frame.setDefaultCloseOperation(3);
        BoxLayoutDemo.addComponentsToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoxLayoutDemo.createAndShowGUI();
            }
        });
    }
}

