/*
 * Decompiled with CFR 0.152.
 */
package layout.ok;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class BoxAlignmentDemo
extends JPanel {
    public BoxAlignmentDemo() {
        super(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel buttonRow = new JPanel();
        buttonRow.add(this.createButtonRow(false));
        buttonRow.add(this.createButtonRow(true));
        tabbedPane.addTab("Altering alignments", buttonRow);
        JPanel labelAndComponent = new JPanel();
        labelAndComponent.add(this.createLabelAndComponent(false));
        labelAndComponent.add(this.createLabelAndComponent(true));
        tabbedPane.addTab("X alignment mismatch", labelAndComponent);
        JPanel buttonAndComponent = new JPanel();
        buttonAndComponent.add(this.createYAlignmentExample(false));
        buttonAndComponent.add(this.createYAlignmentExample(true));
        tabbedPane.addTab("Y alignment mismatch", buttonAndComponent);
        this.add((Component)tabbedPane, "Center");
    }

    protected JPanel createButtonRow(boolean changeAlignment) {
        String title;
        JButton button1 = new JButton("A JButton", BoxAlignmentDemo.createImageIcon("images/middle.gif"));
        button1.setVerticalTextPosition(3);
        button1.setHorizontalTextPosition(0);
        JButton button2 = new JButton("Another JButton", BoxAlignmentDemo.createImageIcon("images/geek-cght.gif"));
        button2.setVerticalTextPosition(3);
        button2.setHorizontalTextPosition(0);
        if (changeAlignment) {
            title = "Desired";
            button1.setAlignmentY(1.0f);
            button2.setAlignmentY(1.0f);
        } else {
            title = "Default";
        }
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createTitledBorder(title));
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(button1);
        pane.add(button2);
        return pane;
    }

    protected JPanel createLabelAndComponent(boolean doItRight) {
        String title;
        JPanel pane = new JPanel();
        JPanel component = new JPanel();
        Dimension size = new Dimension(150, 100);
        component.setMaximumSize(size);
        component.setPreferredSize(size);
        component.setMinimumSize(size);
        TitledBorder border = new TitledBorder(new LineBorder(Color.black), "A JPanel", 2, 3);
        border.setTitleColor(Color.black);
        component.setBorder(border);
        JLabel label = new JLabel("This is a JLabel");
        if (doItRight) {
            title = "Matched";
            label.setAlignmentX(0.5f);
        } else {
            title = "Mismatched";
        }
        pane.setBorder(BorderFactory.createTitledBorder(title));
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(label);
        pane.add(component);
        return pane;
    }

    protected JPanel createYAlignmentExample(boolean doItRight) {
        String title;
        JPanel pane = new JPanel();
        JPanel component1 = new JPanel();
        Dimension size = new Dimension(100, 50);
        component1.setMaximumSize(size);
        component1.setPreferredSize(size);
        component1.setMinimumSize(size);
        TitledBorder border = new TitledBorder(new LineBorder(Color.black), "A JPanel", 2, 3);
        border.setTitleColor(Color.black);
        component1.setBorder(border);
        JPanel component2 = new JPanel();
        size = new Dimension(100, 50);
        component2.setMaximumSize(size);
        component2.setPreferredSize(size);
        component2.setMinimumSize(size);
        border = new TitledBorder(new LineBorder(Color.black), "A JPanel", 2, 3);
        border.setTitleColor(Color.black);
        component2.setBorder(border);
        if (doItRight) {
            title = "Matched";
        } else {
            component1.setAlignmentY(0.0f);
            title = "Mismatched";
        }
        pane.setBorder(BorderFactory.createTitledBorder(title));
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(component1);
        pane.add(component2);
        return pane;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = BoxAlignmentDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("BoxAlignmentDemo");
        frame.setDefaultCloseOperation(3);
        BoxAlignmentDemo newContentPane = new BoxAlignmentDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoxAlignmentDemo.createAndShowGUI();
            }
        });
    }
}

