/*
 * Decompiled with CFR 0.152.
 */
package layout.ok;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.fuin.utils4swing.layout.scalable.DefaultScalableLayoutRegistry;
import org.fuin.utils4swing.layout.scalable.ScalableLayoutUtils;

public class BorderLayoutDemo {
    public static boolean RIGHT_TO_LEFT = false;

    public static void addComponentsToPane(Container pane) {
        if (!(pane.getLayout() instanceof BorderLayout)) {
            pane.add(new JLabel("Container doesn't use BorderLayout!"));
            return;
        }
        if (RIGHT_TO_LEFT) {
            pane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JButton button = new JButton("Button 1 (PAGE_START)");
        pane.add((Component)button, "First");
        button = new JButton("Button 2 (CENTER)");
        button.setPreferredSize(new Dimension(200, 100));
        pane.add((Component)button, "Center");
        button = new JButton("Button 3 (LINE_START)");
        pane.add((Component)button, "Before");
        button = new JButton("Long-Named Button 4 (PAGE_END)");
        pane.add((Component)button, "Last");
        button = new JButton("5 (LINE_END)");
        pane.add((Component)button, "After");
    }

    private static String getStackTrace() {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("BorderLayoutDemo");
        frame.setDefaultCloseOperation(3);
        BorderLayoutDemo.addComponentsToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
        ScalableLayoutUtils.installScalableLayoutAndKeys(new DefaultScalableLayoutRegistry(), frame, 0.1);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BorderLayoutDemo.createAndShowGUI();
            }
        });
    }
}

