/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.progress;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.progress.Cancelable;
import org.fuin.utils4swing.progress.FileCopyProgressPanel;

public final class FileCopyProgressMonitor {
    private static final String DEFAULT_TRANSFER_TEXT = "Transferring file $N of $M...";
    private static final String DEFAULT_TITLE = "File Copy Progress";
    private static final String DEFAULT_SOURCE_LABEL = "Source:";
    private static final String DEFAULT_DESTINATION_LABEL = "Destination:";
    private final Cancelable cancelable;
    private final String title;
    private final int fileMax;
    private final String transferText;
    private final String srcLabelText;
    private final String destLabelText;
    private JFrame frame = null;
    private FileCopyProgressPanel panel = null;
    private boolean firstTime = true;

    public FileCopyProgressMonitor(Cancelable cancelable, String title, int fileMax) {
        this(cancelable, title, null, null, null, fileMax);
    }

    public FileCopyProgressMonitor(Cancelable cancelable, String title, String transferText, String srcLabelText, String destLabelText, int fileMax) {
        this.cancelable = cancelable;
        this.title = title == null ? DEFAULT_TITLE : title;
        this.transferText = transferText == null ? DEFAULT_TRANSFER_TEXT : transferText;
        this.srcLabelText = srcLabelText == null ? DEFAULT_SOURCE_LABEL : srcLabelText;
        this.destLabelText = destLabelText == null ? DEFAULT_DESTINATION_LABEL : destLabelText;
        this.fileMax = fileMax;
    }

    public final int getFileMax() {
        return this.fileMax;
    }

    public final String getTransferText() {
        return this.transferText;
    }

    public final String getTitle() {
        return this.title;
    }

    public final Cancelable getCancelable() {
        return this.cancelable;
    }

    public final String getSrcLabelText() {
        return this.srcLabelText;
    }

    public final String getDestLabelText() {
        return this.destLabelText;
    }

    public final void open() {
        if (this.firstTime) {
            this.firstTime = false;
            if (SwingUtilities.isEventDispatchThread()) {
                this.openIntern();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            FileCopyProgressMonitor.this.openIntern();
                        }
                    });
                }
                catch (Exception ex) {
                    FileCopyProgressMonitor.ignore();
                }
            }
        } else {
            throw new IllegalStateException("This object cannot be reused!");
        }
    }

    private final void openIntern() {
        this.panel = new FileCopyProgressPanel();
        this.panel.setTransferText(this.transferText);
        this.panel.setTitle(this.title);
        this.panel.setCurrentFile(0);
        this.panel.setMaxFile(this.fileMax);
        this.panel.setCurrentByte(0);
        this.panel.setMaxByte(0);
        this.panel.setSourceFile("");
        this.panel.setDestFile("");
        this.panel.setCancelable(this.cancelable);
        this.panel.setDestText(this.destLabelText);
        this.panel.setSourceText(this.srcLabelText);
        this.frame = Utils4Swing.createShowAndPosition(this.title, this.panel, false, new ScreenCenterPositioner());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                if (FileCopyProgressMonitor.this.cancelable != null) {
                    FileCopyProgressMonitor.this.panel.setCancelable(null);
                    FileCopyProgressMonitor.this.cancelable.cancel();
                }
            }
        });
    }

    public final void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.closeIntern();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FileCopyProgressMonitor.this.closeIntern();
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressMonitor.ignore();
            }
        }
    }

    private final void closeIntern() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.panel = null;
            this.frame = null;
        }
    }

    public final void updateFile(String sourceFile, String destFile, int currentFile, int fileSize) {
        if (this.panel != null) {
            this.panel.updateFile(sourceFile, destFile, currentFile, fileSize);
        }
    }

    public final void updateByte(int n) {
        if (this.panel != null) {
            this.panel.setCurrentByte(n);
        }
    }

    public final boolean isCanceled() {
        if (this.cancelable == null) {
            return false;
        }
        return this.cancelable.isCanceled();
    }

    private static void ignore() {
    }

    public static void main(String[] args) {
        Utils4Swing.initSystemLookAndFeel();
        Runnable runnable = new Runnable(){
            private volatile boolean canceled = false;

            public void run() {
                Cancelable cancelable = new Cancelable(){

                    public void cancel() {
                        canceled = true;
                    }

                    public boolean isCanceled() {
                        return canceled;
                    }
                };
                FileCopyProgressMonitor monitor = new FileCopyProgressMonitor(cancelable, "Copy Test", 10);
                monitor.open();
                try {
                    int i = 0;
                    while (i < 10) {
                        if (this.canceled) {
                            break;
                        }
                        int n = i + 1;
                        String fileName = "file" + n + ".jar";
                        int fileSize = n * 10;
                        monitor.updateFile("http://www.fuin.org/demo-app/" + fileName, "/program files/demo app/" + fileName, n, fileSize);
                        int j = 0;
                        while (j < fileSize) {
                            monitor.updateByte(j + 1);
                            this.sleep(100);
                            ++j;
                        }
                        ++i;
                    }
                }
                finally {
                    monitor.close();
                }
            }

            private void sleep(int ms) {
                try {
                    Thread.sleep(ms);
                }
                catch (InterruptedException ex) {
                    FileCopyProgressMonitor.ignore();
                }
            }
        };
        new Thread(runnable).start();
    }
}

