/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.progress;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fuin.utils4swing.progress.FileCopyProgressMonitor;

public class FileCopyProgressInputStream
extends FilterInputStream {
    private final FileCopyProgressMonitor monitor;
    private int bytesRead = 0;
    private int size = 0;

    public FileCopyProgressInputStream(FileCopyProgressMonitor monitor, InputStream inputStream, int size) {
        super(inputStream);
        this.monitor = monitor;
        this.size = size;
    }

    public final int read() throws IOException {
        int count = this.in.read();
        if (count >= 0) {
            ++this.bytesRead;
            this.monitor.updateByte(this.bytesRead);
        }
        return count;
    }

    public final int read(byte[] b) throws IOException {
        int count = this.in.read(b);
        if (count > 0) {
            this.bytesRead += count;
            this.monitor.updateByte(this.bytesRead);
        }
        return count;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int count = this.in.read(b, off, len);
        if (count > 0) {
            this.bytesRead += count;
            this.monitor.updateByte(this.bytesRead);
        }
        return count;
    }

    public final long skip(long n) throws IOException {
        long count = this.in.skip(n);
        if (count > 0L) {
            long p = (long)this.bytesRead + count;
            if (p > Integer.MAX_VALUE) {
                this.bytesRead = this.size;
            }
            this.monitor.updateByte(this.bytesRead);
        }
        return count;
    }

    public final void close() throws IOException {
        this.in.close();
    }

    public final synchronized void reset() throws IOException {
        this.in.reset();
        this.bytesRead = this.size - this.in.available();
        this.monitor.updateByte(this.bytesRead);
    }
}

