/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.dialogs;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.dialogs.CanceledException;
import org.fuin.utils4swing.dialogs.DirectorySelectionPanel;
import org.fuin.utils4swing.dialogs.DirectorySelectorListener;

public class DirectorySelector {
    private JFrame frame = null;
    private DirectorySelectionPanel panel = null;
    private boolean firstTime = true;
    private final String title;
    private final DirectorySelectorListener listener;
    private final String directory;

    public DirectorySelector(String title, String directory, DirectorySelectorListener listener) {
        if (title == null) {
            throw new IllegalArgumentException("The argument 'title' cannot be null!");
        }
        this.title = title;
        if (directory == null) {
            throw new IllegalArgumentException("The argument 'directory' cannot be null!");
        }
        this.directory = directory;
        if (listener == null) {
            throw new IllegalArgumentException("The argument 'listener' cannot be null!");
        }
        this.listener = listener;
    }

    public final void show() {
        if (this.firstTime) {
            this.firstTime = false;
            if (SwingUtilities.isEventDispatchThread()) {
                this.showIntern();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            DirectorySelector.this.showIntern();
                        }
                    });
                }
                catch (Exception ex) {
                    DirectorySelector.ignore();
                }
            }
        } else {
            throw new IllegalStateException("This object cannot be reused!");
        }
    }

    private final void showIntern() {
        this.panel = new DirectorySelectionPanel(this);
        this.panel.setTitle(this.title);
        this.panel.setDirectory(this.directory);
        this.frame = Utils4Swing.createShowAndPosition(this.title, this.panel, false, new ScreenCenterPositioner());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                DirectorySelector.this.cancel();
            }
        });
    }

    protected final void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.closeIntern();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DirectorySelector.this.closeIntern();
                    }
                });
            }
            catch (Exception ex) {
                DirectorySelector.ignore();
            }
        }
    }

    private final void closeIntern() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.panel = null;
            this.frame = null;
        }
    }

    protected final void cancel() {
        this.close();
        this.listener.canceled();
    }

    protected final void ok() {
        String dir = this.panel.getDirectory();
        this.close();
        this.listener.finished(dir);
    }

    private static void ignore() {
    }

    public static String selectDirectory(String title, String directory) throws CanceledException {
        class MyListener
        implements DirectorySelectorListener {
            private volatile String directory = null;

            MyListener() {
            }

            public String getDirectory() {
                return this.directory;
            }

            public void canceled() {
                this.directory = "";
            }

            public void finished(String directory) {
                this.directory = directory;
            }
        }
        MyListener listener = new MyListener();
        new DirectorySelector(title, directory, listener).show();
        while (listener.getDirectory() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                DirectorySelector.ignore();
            }
        }
        if (listener.getDirectory().length() == 0) {
            throw new CanceledException();
        }
        return listener.getDirectory();
    }

    public static void main(String[] args) throws IOException {
        Utils4Swing.initSystemLookAndFeel();
        File file = new File(".");
        DirectorySelector selector = new DirectorySelector("Please select the destination directory:", file.getCanonicalPath(), new DirectorySelectorListener(){

            public void canceled() {
                System.out.println("CANCELED!");
            }

            public void finished(String directory) {
                System.out.println("SELECTED=" + directory);
            }
        });
        selector.show();
    }
}

