/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.FramePositioner;

public final class Utils4Swing {
    private Utils4Swing() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static JFrame createShowAndPosition(String title, Container content, boolean exitOnClose, FramePositioner positioner) {
        return Utils4Swing.createShowAndPosition(title, content, exitOnClose, true, positioner);
    }

    public static JFrame createShowAndPosition(String title, Container content, boolean exitOnClose, boolean resizable, FramePositioner positioner) {
        JFrame frame = new JFrame(title);
        frame.setContentPane(content);
        if (exitOnClose) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(1);
        }
        frame.setSize(content.getPreferredSize());
        positioner.position(frame);
        Insets insets = frame.getInsets();
        frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
        frame.setVisible(true);
        frame.setResizable(resizable);
        return frame;
    }

    public static ImageIcon loadIcon(Class clasz, String name) {
        URL url = Utils4J.getResource((Class)clasz, (String)name);
        return new ImageIcon(url);
    }

    private static void initLookAndFeelIntern(String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing the Look And Feel!", e);
        }
    }

    public static void initLookAndFeel(final String className) {
        if (SwingUtilities.isEventDispatchThread()) {
            Utils4Swing.initLookAndFeelIntern(className);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Utils4Swing.initLookAndFeelIntern(className);
                    }
                });
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void initSystemLookAndFeel() {
        Utils4Swing.initLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public static RootPaneContainer findRootPaneContainer(Component source) {
        Component comp = source;
        while (comp != null && !(comp instanceof RootPaneContainer)) {
            comp = comp.getParent();
        }
        if (comp instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)comp);
        }
        return null;
    }

    public static GlassPaneState showGlassPane(Component source) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        RootPaneContainer rootPaneContainer = Utils4Swing.findRootPaneContainer(source);
        Component glassPane = rootPaneContainer.getGlassPane();
        MouseAdapter mouseListener = new MouseAdapter(){};
        Cursor cursor = glassPane.getCursor();
        glassPane.addMouseListener(mouseListener);
        glassPane.setVisible(true);
        glassPane.requestFocus();
        glassPane.setCursor(new Cursor(3));
        return new GlassPaneState(glassPane, mouseListener, focusOwner, cursor);
    }

    public static void hideGlassPane(GlassPaneState state) {
        Component glassPane = state.getGlassPane();
        glassPane.removeMouseListener(state.getMouseListener());
        glassPane.setCursor(state.getCursor());
        glassPane.setVisible(false);
        if (state.getFocusOwner() != null) {
            state.getFocusOwner().requestFocus();
        }
    }

    public static final class GlassPaneState {
        private final Component glassPane;
        private final MouseListener mouseListener;
        private final Component focusOwner;
        private final Cursor cursor;

        public GlassPaneState(Component glassPane, MouseListener mouseListener, Component focusOwner, Cursor cursor) {
            this.glassPane = glassPane;
            this.mouseListener = mouseListener;
            this.focusOwner = focusOwner;
            this.cursor = cursor;
        }

        public final Component getGlassPane() {
            return this.glassPane;
        }

        public final MouseListener getMouseListener() {
            return this.mouseListener;
        }

        public final Component getFocusOwner() {
            return this.focusOwner;
        }

        public final Cursor getCursor() {
            return this.cursor;
        }
    }
}

