/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appstarter;

import javax.swing.SwingUtilities;
import org.fuin.utils4swing.appstarter.AppStarter;
import org.fuin.utils4swing.appstarter.AppStarterConfig;
import org.fuin.utils4swing.appstarter.AppStarterListener;
import org.fuin.utils4swing.appstarter.ClasspathBinDirEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarFileEntry;
import org.fuin.utils4swing.appstarter.ClasspathJarsDirEntry;
import org.fuin.utils4swing.appstarter.StartApplicationException;
import org.fuin.utils4swing.appstarter.StartType;
import org.fuin.utils4swing.common.Utils4Swing;

public final class Examples {
    private Examples() {
        throw new UnsupportedOperationException("Creating an instance is not allowed (utility class!)!");
    }

    private static AppStarterConfig createExampleConfig() {
        AppStarterConfig config = new AppStarterConfig();
        config.setFrameTitle("MyAppStarter");
        config.setStartType(StartType.APPLICATION);
        config.addClasspathEntry(new ClasspathJarFileEntry("C:\\swing-examples\\password-store-example.jar"));
        config.addClasspathEntry(new ClasspathJarsDirEntry("C:\\swing-examples\\lib"));
        config.addClasspathEntry(new ClasspathBinDirEntry("C:\\swing-examples\\classes"));
        config.setMainClass("passwordstore.ui.PasswordStoreApplication");
        config.addArgument("useless");
        config.addArgument("dummy");
        config.addArgument("arguments");
        return config;
    }

    private static void prepopulateConfigScreen() {
        final AppStarterConfig config = Examples.createExampleConfig();
        final AppStarterListener listener = new AppStarterListener(){

            public void appStarted() {
                System.out.println("The 3rd Party application has just started!");
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Utils4Swing.initSystemLookAndFeel();
                new AppStarter(config, listener).execute();
            }
        });
    }

    private static void startEmptyConfigScreen() {
        final AppStarterConfig config = new AppStarterConfig();
        config.setFrameTitle("MyAppStarter");
        final AppStarterListener listener = new AppStarterListener(){

            public void appStarted() {
                System.out.println("The 3rd Party application has just started!");
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Utils4Swing.initSystemLookAndFeel();
                new AppStarter(config, listener).execute();
            }
        });
    }

    private static void startWithoutConfigScreen() {
        final AppStarterConfig config = Examples.createExampleConfig();
        final AppStarterListener listener = new AppStarterListener(){

            public void appStarted() {
                System.out.println("The 3rd Party application has just started!");
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Utils4Swing.initSystemLookAndFeel();
                try {
                    AppStarter.start(config.getStartType(), config.getClassPath(), config.getMainClass(), config.getArguments(), listener);
                }
                catch (StartApplicationException e) {
                    throw new RuntimeException("Sorry, starting the target app failed!", e);
                }
            }
        });
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            Examples.startEmptyConfigScreen();
        } else if (args[0].equalsIgnoreCase("prepopulate")) {
            Examples.prepopulateConfigScreen();
        } else if (args[0].equalsIgnoreCase("start")) {
            Examples.startWithoutConfigScreen();
        } else {
            Examples.startEmptyConfigScreen();
        }
    }
}

