/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.appletviewer;

import java.applet.Applet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import org.fuin.utils4j.Utils4J;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleAppletViewerConfig {
    private String title = "Simple Applet Viewer";
    private int width = 800;
    private int height = 600;
    private String name = null;
    private String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
    private String baseDir;
    @Argument
    private List<String> arguments = new ArrayList<String>();
    private Applet applet;

    public SimpleAppletViewerConfig() {
        this.baseDir = System.getProperty("user.dir");
    }

    public final int getHeight() {
        return this.height;
    }

    @Option(name="-height", usage="Sets the height of the viewer frame")
    public final void setHeight(int height) {
        this.height = height;
    }

    public final int getWidth() {
        return this.width;
    }

    @Option(name="-width", usage="Sets the width of the viewer frame")
    public final void setWidth(int width) {
        this.width = width;
    }

    public final String getName() {
        return this.name;
    }

    @Option(name="-name", usage="Sets the name of the applet")
    public final void setName(String name) {
        this.name = name;
    }

    public final String getTitle() {
        return this.title;
    }

    @Option(name="-title", usage="Sets the title of the frame")
    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getLookAndFeel() {
        return this.lookAndFeel;
    }

    @Option(name="-lookAndFeel", usage="Sets the look and feel of the viewer")
    public final void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public final String getBaseDir() {
        return this.baseDir;
    }

    @Option(name="-baseDir", usage="Sets the base directory for the applet")
    public final void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public final List<String> getArguments() {
        return this.arguments;
    }

    public final void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public final URL getBaseUrl() {
        try {
            return new File(this.baseDir).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error converting 'baseDir' into 'baseUrl'!", e);
        }
    }

    public final Applet getApplet() {
        return this.applet;
    }

    public final void setApplet(Applet applet) {
        this.applet = applet;
    }

    @Option(name="-applet", usage="Full qualified applet class name", required=true)
    public final void setApplet(String applet) {
        this.applet = (Applet)Utils4J.createInstance((String)applet);
    }

    public final Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < this.arguments.size()) {
            String argument = this.arguments.get(i);
            int p = argument.indexOf(61);
            if (p > -1) {
                String key = argument.substring(0, p);
                String value = argument.substring(p + 1, argument.length());
                params.put(key, value);
            }
            ++i;
        }
        return params;
    }

    public final void addArgument(String arg) {
        this.arguments.add(arg);
    }

    public final void addArgument(String key, String value) {
        this.arguments.add(String.valueOf(key) + "=" + value);
    }
}

