/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.glazedlists;

import ca.odell.glazedlists.gui.TableFormat;

/**
 * Adds a column width information to the table format. 
 * 
 * @param <E>
 *            A  business class annotated with <code>@TableColumn</code>.
 */
public interface TableFormatExt<E> extends TableFormat<E> {

	/**
	 * Returns the width for a given column.
	 * 
	 * @param column Column number (0..N).
	 * 
	 * @return Preferred width of the column.
	 */
	public int getColumnWidth(int column);
	
}
