/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appstarter;

import java.io.File;

import org.fuin.utils4j.Utils4J;

/**
 * Directory with several JAR files to be added to the classpath.
 */
public final class ClasspathJarsDirEntry implements ClasspathEntry {

    /** Unique type name. */
    public static final String TYPE = "JARS_DIR";

    private final File dir;

    /**
     * Constructor with directory name.
     * 
     * @param dir
     *            Path.
     */
    public ClasspathJarsDirEntry(final String dir) {
        this(new File(dir));
    }

    /**
     * Constructor with directory reference.
     * 
     * @param dir
     *            Directory.
     */
    public ClasspathJarsDirEntry(final File dir) {
        super();
        if (dir == null) {
            throw new IllegalArgumentException("The argument 'dir' cannot be null!");
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("The directory '" + dir + "' does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The argument '" + dir
                    + "' is not a directory!");
        }
        this.dir = dir;
    }

    /**
     * {@inheritDoc}
     */
    public final String getType() {
        return TYPE;
    }

    /**
     * {@inheritDoc}
     */
    public final String getValue() {
        return dir.toString();
    }

    /**
     * {@inheritDoc}
     */
    public final void addToClasspath() {
        final File[] files = dir.listFiles();
        for (final File element : files) {
            if (element.getName().endsWith(".jar")) {
                Utils4J.addToClasspath(element.toURI().toString());
            }
        }
    }

}
