/**
 * Copyright (C) 2009 Future Invent Informationsmanagement GmbH. All rights
 * reserved. <http://www.fuin.org/>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
package org.fuin.utils4swing.appstarter;

import java.io.File;

import org.fuin.utils4j.Utils4J;

/**
 * Single JAR to be added to the classpath.
 */
public final class ClasspathJarFileEntry implements ClasspathEntry {

    /** Unique type name. */
    public static final String TYPE = "JAR_FILE";

    private final File file;

    /**
     * Constructor with filename.
     * 
     * @param file
     *            Jar path and filename.
     */
    public ClasspathJarFileEntry(final String file) {
        this(new File(file));
    }

    /**
     * Constructor with file reference.
     * 
     * @param file
     *            Jar file.
     */
    public ClasspathJarFileEntry(final File file) {
        super();
        if (file == null) {
            throw new IllegalArgumentException("The argument 'file' cannot be null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The file '" + file + "' does not exist!");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("The argument '" + file + "' is not a file!");
        }
        this.file = file;
    }

    /**
     * {@inheritDoc}
     */
    public final String getType() {
        return TYPE;
    }

    /**
     * {@inheritDoc}
     */
    public final String getValue() {
        return file.toString();
    }

    /**
     * {@inheritDoc}
     */
    public final void addToClasspath() {
        Utils4J.addToClasspath(file.toURI().toString());
    }

}
